/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.recipeBooks;

import com.ssomar.score.SCore;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.utils.emums.RecipeType;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.config.messages.Message;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeInput;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.recipeBooks.CraftingStationsUtils;
import vayk.executablecrafting.recipeBooks.ItemBuilder;
import vayk.executablecrafting.recipeBooks.RecipeBook;
import vayk.executablecrafting.recipeBooks.RecipeBookManagementDialogs;
import vayk.executablecrafting.recipeBooks.RecipeInventoryManager;
import vayk.executablecrafting.recipeBooks.Text;

public class RecipeBookManagement {
    private static RecipeBookManagement instance = null;
    public static File recipeBookFile = null;
    public static HashMap<String, RecipeBook> recipeBooks = new HashMap();
    public static String nextPage = null;
    public static Material nextPageMaterial = null;
    public static Integer nextPageCustomModelData = null;
    public static String previousPage = null;
    public static Material previousPageMaterial = null;
    public static Integer previousPageCustomModelData = null;
    public static String noMorePages = null;
    public static Material noMorePagesMaterial = null;
    public static Integer noMorePagesCustomModelData = null;
    public static String noPreviousPages = null;
    public static Material noPreviousPagesMaterial = null;
    public static Integer noPreviousPagesCustomModelData = null;
    public static String goBack = null;
    public static Material goBackMaterial = null;
    public static Integer goBackCustomModelData = null;
    public static ItemStack itemDefault = null;
    public static String itemDefaultName = null;
    public static Material itemDefaultMaterial = null;
    public static Integer itemDefaultCustomModelData = null;
    public static String craftingTableName = null;
    public static List<String> craftingTableLore = null;
    public static Integer craftingTableCustomModelData = null;
    public static String furnaceName = null;
    public static List<String> furnaceLore = null;
    public static Integer furnaceCustomModelData = null;

    public static RecipeBookManagement getInstance() {
        if (instance == null) {
            instance = new RecipeBookManagement();
        }
        return instance;
    }

    public static void buildRecipeStrings() {
        nextPage = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NEXT_PAGE_NAME);
        nextPageMaterial = Material.getMaterial((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NEXT_PAGE_MATERIAL));
        nextPageCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NEXT_PAGE_CUSTOM_MODEL_DATA)).orElse(0);
        if (nextPageMaterial == null) {
            nextPageMaterial = Material.ANVIL;
        }
        previousPage = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_PREVIOUS_PAGE_NAME);
        previousPageMaterial = Material.getMaterial((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_PREVIOUS_PAGE_MATERIAL));
        previousPageCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_PREVIOUS_PAGE_CUSTOM_MODEL_DATA)).orElse(0);
        if (previousPageMaterial == null) {
            previousPageMaterial = Material.ANVIL;
        }
        noMorePages = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NO_MORE_PAGES_NAME);
        noMorePagesMaterial = Material.getMaterial((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NO_MORE_PAGES_MATERIAL));
        noMorePagesCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NO_MORE_PAGES_CUSTOM_MODEL_DATA)).orElse(0);
        if (noMorePagesMaterial == null) {
            noMorePagesMaterial = Material.RED_STAINED_GLASS_PANE;
        }
        noPreviousPages = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NO_PREVIOUS_PAGES_NAME);
        noPreviousPagesMaterial = Material.getMaterial((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NO_PREVIOUS_PAGES_MATERIAL));
        noPreviousPagesCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_NO_PREVIOUS_PAGES_CUSTOM_MODEL_DATA)).orElse(0);
        if (noPreviousPagesMaterial == null) {
            noPreviousPagesMaterial = Material.RED_STAINED_GLASS_PANE;
        }
        goBack = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_GO_BACK_NAME);
        goBackMaterial = Material.getMaterial((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_GO_BACK_MATERIAL));
        goBackCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_GO_BACK_CUSTOM_MODEL_DATA)).orElse(0);
        if (goBackMaterial == null) {
            goBackMaterial = Material.ANVIL;
        }
        itemDefaultName = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_DEFAULT_NAME);
        itemDefaultMaterial = Material.getMaterial((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_DEFAULT_MATERIAL));
        itemDefaultCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_DEFAULT_CUSTOM_MODEL_DATA)).orElse(0);
        if (itemDefaultMaterial == null) {
            itemDefaultMaterial = Material.BLACK_STAINED_GLASS_PANE;
        }
        itemDefault = new ItemBuilder(itemDefaultMaterial).setName(itemDefaultName).setCustomModelData(itemDefaultCustomModelData).setInvisible().build();
        craftingTableName = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_CRAFTING_STATIONS_CRAFTING_TABLE_NAME);
        craftingTableLore = Text.differentLines(MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_CRAFTING_STATIONS_CRAFTING_TABLE_LORE));
        craftingTableCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_CRAFTING_STATIONS_CRAFTING_TABLE_CUSTOM_MODEL_DATA)).orElse(0);
        furnaceName = MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_CRAFTING_STATIONS_FURNACE_NAME);
        furnaceLore = Text.differentLines(MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_CRAFTING_STATIONS_FURNACE_LORE));
        furnaceCustomModelData = NTools.getInteger((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_ITEM_CRAFTING_STATIONS_FURNACE_CUSTOM_MODEL_DATA)).orElse(0);
    }

    public RecipeBookManagement() {
        RecipeBookManagement.buildRecipeStrings();
        recipeBookFile = new File(ExecutableCrafting.plugin.getDataFolder(), "recipeBooks.yml");
        if (!recipeBookFile.exists()) {
            try {
                File defaultLocaleFile = new File(ExecutableCrafting.plugin.getDataFolder(), "recipeBooks.yml");
                if (!defaultLocaleFile.exists()) {
                    try (InputStream inputStream = ExecutableCrafting.plugin.getResource("recipeBooks.yml");){
                        Files.copy(inputStream, defaultLocaleFile.toPath(), new CopyOption[0]);
                    }
                }
                if (!recipeBookFile.getName().equals("recipeBooks.yml")) {
                    recipeBookFile.createNewFile();
                    Files.copy(defaultLocaleFile.toPath(), recipeBookFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String parseTitle(String title, String key, String recipe, String folder, String page, String resultName) {
        if (key != null) {
            title = title.replace("%bookID%", "&r" + key + "&r");
        }
        if (recipe != null) {
            title = title.replace("%recipe%", "&r" + recipe + "&r");
        }
        if (folder != null) {
            title = title.replace("%folder%", "&r" + folder + "&r");
            title = title.replace("color:", "");
        }
        if (page != null) {
            title = title.replace("%page%", "&r" + page + "&r");
        }
        if (resultName != null) {
            title = title.replace("%resultName%", "&r" + resultName + "&r");
        }
        return title;
    }

    public void loadRecipeBook() {
        List recipesLoadedMap = RecipeManager.getInstance().getLoadedObjects();
        recipeBooks = new HashMap();
        if (!recipeBookFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeBookFile);
        ConfigurationSection recipeBooksSection = config.getConfigurationSection("recipeBooks");
        if (recipeBooksSection == null) {
            return;
        }
        int i = 0;
        for (String key : recipeBooksSection.getKeys(false)) {
            if (i == 5 && ExecutableCrafting.plugin.isLotOfWork()) {
                Utils.sendConsoleMsg((String)"&cYou can't load more than 5 recipe books in the free version.");
                break;
            }
            RecipeBook book = new RecipeBook();
            ++i;
            List recipes = recipeBooksSection.getStringList(key + ".recipes");
            for (String recipe : recipes) {
                if (recipe.contains("_*")) {
                    String start = recipe.replace("_*", "");
                    for (Recipe recipesLoaded : recipesLoadedMap) {
                        if (!recipesLoaded.getId().startsWith(start)) continue;
                        book.addRecipe(recipesLoaded.getId());
                    }
                    continue;
                }
                if (recipe.equalsIgnoreCase("**")) {
                    for (Recipe recipesLoaded : recipesLoadedMap) {
                        book.addRecipe(recipesLoaded.getId());
                    }
                    continue;
                }
                book.addRecipe(recipe);
            }
            ConfigurationSection foldersSection = recipeBooksSection.getConfigurationSection(key + ".folders");
            if (foldersSection != null) {
                for (String folderName : foldersSection.getKeys(false)) {
                    List folderRecipes = foldersSection.getStringList(folderName);
                    ArrayList<String> recipes2 = new ArrayList<String>();
                    for (String recipeCheck : folderRecipes) {
                        if (recipeCheck.contains("_*")) {
                            String start = recipeCheck.replace("_*", "");
                            for (Recipe recipesLoaded : recipesLoadedMap) {
                                if (!recipesLoaded.getId().startsWith(start)) continue;
                                recipes2.add(recipesLoaded.getId());
                            }
                            continue;
                        }
                        if (recipeCheck.equalsIgnoreCase("**")) {
                            recipes2.addAll(recipesLoadedMap.stream().map(SObject::getId).toList());
                            continue;
                        }
                        recipes2.add(recipeCheck);
                    }
                    book.addFolder(folderName, recipes2);
                }
            }
            recipeBooks.put(key, book);
        }
        Utils.sendConsoleMsg((String)(ExecutableCrafting.plugin.getNameDesign() + " &7Amount of Recipe's books loaded: &e" + i));
    }

    public void openRecipeBook(Player player, String key, String page) {
        if (!recipeBooks.containsKey(key)) {
            return;
        }
        RecipeBook book = recipeBooks.get(key);
        String title = StringConverter.coloredString((String)RecipeBookManagement.parseTitle(StringConverter.coloredString((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_TITLE_MAIN_GUI)), key, null, null, page, null));
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
        int currentPage = Integer.parseInt(page);
        int itemsPerPage = 52;
        ArrayList<String> combinedItems = new ArrayList<String>();
        HashMap<String, List<String>> folders = book.getFolders();
        for (String folderName : folders.keySet()) {
            combinedItems.add("folder:" + folderName);
        }
        combinedItems.addAll(book.getRecipes());
        int totalItems = combinedItems.size();
        int totalPages = (int)Math.ceil((double)totalItems / (double)itemsPerPage);
        if (currentPage < totalPages) {
            gui.setItem(53, new ItemBuilder(nextPageMaterial).setName(nextPage).setCustomModelData(nextPageCustomModelData).build());
        } else {
            gui.setItem(53, new ItemBuilder(noMorePagesMaterial).setName(noMorePages).setCustomModelData(noMorePagesCustomModelData).build());
        }
        if (currentPage > 1) {
            gui.setItem(45, new ItemBuilder(previousPageMaterial).setName(previousPage).setCustomModelData(previousPageCustomModelData).build());
        } else {
            gui.setItem(45, new ItemBuilder(noPreviousPagesMaterial).setName(noPreviousPages).setCustomModelData(noPreviousPagesCustomModelData).build());
        }
        int startIndex = (Integer.parseInt(page) - 1) * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, combinedItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            String ID = (String)combinedItems.get(i);
            if (ID.startsWith("folder:")) {
                String folderName;
                String folderNameWithColor = folderName = ID.substring(7);
                if (folderName.startsWith("color:")) {
                    folderNameWithColor = folderName.replace("color:", "");
                    folderNameWithColor = StringConverter.coloredString((String)folderNameWithColor);
                }
                ItemStack folderA = new ItemBuilder(Material.CHEST).setName(folderNameWithColor).addPublicBukkit("recipeID", "folder_" + folderName).build();
                gui.addItem(new ItemStack[]{folderA});
                continue;
            }
            if (!RecipeManager.getInstance().isValidID(ID)) continue;
            Recipe recipe = RecipeManager.getInstance().getRecipe(ID).get();
            ItemStack item1 = new ItemBuilder(recipe.getResult().getItemsStack()).addPublicBukkit("recipeID", "recipe_" + ID).build();
            ItemBuilder resultItemB = new ItemBuilder(item1);
            if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.recipeBookNameOfID.name())) {
                resultItemB.setName(ID);
            }
            boolean positive = true;
            if (!recipe.checkConditions((OfflinePlayer)player, null)) {
                positive = false;
                resultItemB.addPublicBukkit("available", "false");
                resultItemB.addLore("&c You don't have the required conditions to craft this item");
            }
            if (positive) {
                resultItemB.addPapiLore(player, Text.differentLines(MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_PLCHD_POSITIVE)));
            }
            gui.addItem(new ItemStack[]{resultItemB.build()});
        }
        player.openInventory(gui);
        RecipeInventoryManager.setMetadata(player.getUniqueId(), new RecipeInventoryManager.Metadata(key, null, null, page));
    }

    public static void openFolderFromRecipeBook(Player player, String key, String folder, String page) {
        if (!recipeBooks.containsKey(key)) {
            return;
        }
        RecipeBook book = recipeBooks.get(key);
        List<String> recipesInFolder = book.getFolders().get(folder);
        if (recipesInFolder == null) {
            return;
        }
        if (ExecutableCrafting.enableDialogsModule && SCore.is1v21v7Plus() && SCore.isPaperOrFork()) {
            new RecipeBookManagementDialogs();
            RecipeBookManagementDialogs.openFolderFromRecipeBook(player, key, folder, page, book);
        } else {
            String title = StringConverter.coloredString((String)RecipeBookManagement.parseTitle(StringConverter.coloredString((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_TITLE_FOLDER)), key, null, folder, page, null));
            Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
            int currentPage = Integer.parseInt(page);
            int recipesPerPage = 51;
            int totalRecipes = recipesInFolder.size();
            int totalPages = (int)Math.ceil((double)totalRecipes / (double)recipesPerPage);
            if (currentPage < totalPages) {
                gui.setItem(53, new ItemBuilder(nextPageMaterial).setName(nextPage).setCustomModelData(nextPageCustomModelData).build());
            } else {
                gui.setItem(53, new ItemBuilder(noMorePagesMaterial).setName(noMorePages).setCustomModelData(noMorePagesCustomModelData).build());
            }
            if (currentPage > 1) {
                gui.setItem(45, new ItemBuilder(previousPageMaterial).setName(previousPage).setCustomModelData(previousPageCustomModelData).build());
            } else {
                gui.setItem(45, new ItemBuilder(noPreviousPagesMaterial).setName(noPreviousPages).setCustomModelData(noPreviousPagesCustomModelData).build());
            }
            gui.setItem(44, new ItemBuilder(goBackMaterial).setName(goBack).build());
            int startIndex = (Integer.parseInt(page) - 1) * recipesPerPage;
            int endIndex = Math.min(startIndex + recipesPerPage, recipesInFolder.size());
            for (int i = startIndex; i < endIndex; ++i) {
                String ID = recipesInFolder.get(i);
                if (ID.startsWith("folder:")) {
                    String folderName;
                    String folderNameWithColor = folderName = ID.substring(7);
                    if (folderName.startsWith("color:")) {
                        folderNameWithColor = folderName.replace("color:", "");
                        folderNameWithColor = StringConverter.coloredString((String)folderNameWithColor);
                    }
                    ItemStack folderB = new ItemBuilder(Material.CHEST).setName(folderNameWithColor).addPublicBukkit("recipeID", "folder_" + folderName).build();
                    gui.addItem(new ItemStack[]{folderB});
                    continue;
                }
                if (!RecipeManager.getInstance().isValidID(ID)) continue;
                Recipe recipe = RecipeManager.getInstance().getRecipe(ID).get();
                ItemStack item1 = new ItemBuilder(recipe.getResult().getItemsStack()).addPublicBukkit("recipeID", "recipe_" + ID).build();
                ItemBuilder resultItemB = new ItemBuilder(item1);
                if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.recipeBookNameOfID.name())) {
                    resultItemB.setName(ID);
                }
                boolean positive = true;
                if (!recipe.checkConditions((OfflinePlayer)player, null)) {
                    positive = false;
                    resultItemB.addPublicBukkit("available", "false");
                    resultItemB.addLore("&c You don't have the required conditions to craft this item");
                }
                if (positive) {
                    resultItemB.addPapiLore(player, Text.differentLines(MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_PLCHD_POSITIVE)));
                }
                gui.addItem(new ItemStack[]{resultItemB.build()});
            }
            player.openInventory(gui);
        }
        RecipeInventoryManager.setMetadata(player.getUniqueId(), new RecipeInventoryManager.Metadata(key, null, folder, "1"));
    }

    public static void openRecipeFromRecipeBook(Player player, String key, String recipe) {
        Optional<Recipe> recipeClassOpt = RecipeManager.getInstance().getRecipe(recipe);
        if (!recipeClassOpt.isPresent()) {
            return;
        }
        Recipe recipeClass = recipeClassOpt.get();
        RecipeType typeOfCrafting = (RecipeType)recipeClass.getType().getValue().get();
        List<RecipeInput> itemsRecipe = recipeClass.getInputs();
        ItemBuilder resultItemB = new ItemBuilder(recipeClass.getResult().getItemsStack()).addPublicBukkit("recipeID", "recipe_" + recipe);
        ItemBuilder typeOfCraftingItemB = null;
        switch (typeOfCrafting) {
            case CRAFTING: {
                typeOfCraftingItemB = new ItemBuilder(Material.CRAFTING_TABLE).setName(craftingTableName).setLore(craftingTableLore).setCustomModelData(craftingTableCustomModelData);
                break;
            }
            case FURNACE: {
                typeOfCraftingItemB = new ItemBuilder(Material.FURNACE).setName(furnaceName).setLore(furnaceLore).setCustomModelData(furnaceCustomModelData);
            }
        }
        if (typeOfCraftingItemB == null) {
            return;
        }
        ItemStack resultItem = resultItemB.build();
        ItemStack typeOfCraftingItem = typeOfCraftingItemB.build();
        String name = resultItem.getItemMeta().hasDisplayName() ? resultItem.getItemMeta().getDisplayName() : ItemBuilder.returnItemName(resultItem);
        String title = StringConverter.coloredString((String)RecipeBookManagement.parseTitle(StringConverter.coloredString((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_TITLE_RECIPE)), key, recipe, null, null, name));
        if (ExecutableCrafting.enableDialogsModule && SCore.isPaperOrFork() && SCore.is1v21v7Plus()) {
            new RecipeBookManagementDialogs().openRecipeFromRecipeBook(player, recipeClass);
        } else {
            int i;
            Inventory recipeGUI = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)title);
            recipeGUI.setItem(15, resultItem);
            recipeGUI.setItem(9, typeOfCraftingItem);
            ArrayList<Integer> arrayUsable = CraftingStationsUtils.getCraftingSlots(typeOfCrafting, false);
            arrayUsable.replaceAll(integer -> integer + 1);
            for (i = 0; i < 27; ++i) {
                if (arrayUsable.contains(i) | i == 15 | i == 17 | i == 9) continue;
                recipeGUI.setItem(i, itemDefault);
            }
            recipeGUI.setItem(17, new ItemBuilder(goBackMaterial).setName(goBack).setCustomModelData(goBackCustomModelData).build());
            for (i = 0; i < itemsRecipe.size(); ++i) {
                if (itemsRecipe.get(i).getItem() == null || itemsRecipe.get(i).getItem().getType() == Material.AIR) continue;
                recipeGUI.setItem(arrayUsable.get(i).intValue(), itemsRecipe.get(i).getItem());
            }
            player.openInventory(recipeGUI);
        }
        RecipeInventoryManager.setMetadata(player.getUniqueId(), new RecipeInventoryManager.Metadata(key, recipe, null, null));
    }
}

