/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.recipeBooks;

import java.util.HashMap;
import java.util.Stack;
import java.util.UUID;

public class RecipeHistoryManager {
    private static final HashMap<UUID, Stack<String>> recipeHistories = new HashMap();

    public static void addRecipeToHistory(UUID playerUUID, String recipe) {
        recipeHistories.putIfAbsent(playerUUID, new Stack());
        recipeHistories.get(playerUUID).push(recipe);
    }

    public static String goBackInHistory(UUID playerUUID) {
        Stack<String> history;
        if (recipeHistories.containsKey(playerUUID) && !(history = recipeHistories.get(playerUUID)).isEmpty()) {
            return history.pop();
        }
        return null;
    }

    public static boolean hasHistory(UUID playerUUID) {
        return !recipeHistories.getOrDefault(playerUUID, new Stack()).isEmpty();
    }

    public static void clearHistory(UUID playerUUID) {
        recipeHistories.remove(playerUUID);
    }
}

