/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.customRecipes.types;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.commands.item.ItemCommandsFeature;
import com.ssomar.score.features.types.ItemStackFeature;
import com.ssomar.score.features.types.enums.EnumFeature;
import com.ssomar.score.utils.emums.AnvilMergeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeInput;

public class RecipeAnvil
extends Recipe {
    private EnumFeature<AnvilMergeType> mergeType;
    private ItemStackFeature input1;
    private ItemStackFeature input2;
    private ItemCommandsFeature itemCommandFeature;

    public RecipeAnvil(FeatureParentInterface parent, String id, String path) {
        super(parent, id, path);
    }

    public RecipeAnvil(String id, String path) {
        super(id, path);
    }

    public RecipeAnvil clone(FeatureParentInterface parent) {
        RecipeAnvil clone = new RecipeAnvil((FeatureParentInterface)this, this.getId(), this.getPath());
        clone.setType(this.getType().clone((FeatureParentInterface)clone));
        clone.setResult(this.getResult().clone((FeatureParentInterface)clone));
        clone.setPlayerConditions(this.getPlayerConditions().clone((FeatureParentInterface)clone));
        clone.setBlockConditions(this.getBlockConditions().clone((FeatureParentInterface)clone));
        clone.setPlaceholderConditions(this.getPlaceholderConditions().clone((FeatureParentInterface)clone));
        clone.setCommands(this.getCommands().clone((FeatureParentInterface)clone));
        clone.setCheckers(this.getCheckers().clone((FeatureParentInterface)clone));
        clone.setMergeType((EnumFeature<AnvilMergeType>)this.mergeType.clone((FeatureParentInterface)clone));
        clone.setInput1(this.input1.clone((FeatureParentInterface)clone));
        clone.setInput2(this.input2.clone((FeatureParentInterface)clone));
        clone.setItemCommandFeature(this.itemCommandFeature.clone((FeatureParentInterface)clone));
        return clone;
    }

    public int isValidGrid(ItemStack item1, ItemStack item2) {
        int i;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(item1);
        items.add(item2);
        ArrayList<RecipeInput> idealItems = new ArrayList<RecipeInput>();
        idealItems.add(new RecipeInput((ItemStack)this.getInput1().getValue().get(), null));
        idealItems.add(new RecipeInput((ItemStack)this.getInput2().getValue().get(), null));
        int maxCraftable = Integer.MAX_VALUE;
        for (i = 0; i < items.size(); ++i) {
            if (this.verifyItemsSimilarity((RecipeInput)idealItems.get(i), (ItemStack)items.get(i))) continue;
            return 0;
        }
        for (i = 0; i < items.size(); ++i) {
            int creatableWithThisItem = ((ItemStack)items.get(i)).getAmount() / ((RecipeInput)idealItems.get(i)).getItem().getAmount();
            maxCraftable = Math.min(maxCraftable, creatableWithThisItem);
        }
        return maxCraftable;
    }

    public ItemStack getResult(int amount) {
        ItemStack resultItem = this.resultItem();
        if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.castResultAsMaxAmount.name())) {
            int resultAmount = resultItem.getAmount() * amount;
            resultItem.setAmount(resultAmount);
        }
        return resultItem;
    }

    @Override
    public void reset() {
        super.reset();
        this.mergeType = new EnumFeature((FeatureParentInterface)this, Optional.of(AnvilMergeType.CUSTOM_RESULT), (FeatureSettingsInterface)FeatureSettingsSCore.anvilMergeType, AnvilMergeType.class, (Enum)AnvilMergeType.CUSTOM_RESULT, "AnvilMergeType", Arrays.asList(AnvilMergeType.values()));
        this.input1 = new ItemStackFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.input1);
        this.input2 = new ItemStackFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.input2);
        this.itemCommandFeature = new ItemCommandsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.itemCommands);
    }

    @Override
    public List<RecipeInput> getInputs() {
        ArrayList<RecipeInput> inputs = new ArrayList<RecipeInput>();
        inputs.add(new RecipeInput(this.getInput1().getItemsStack(), null));
        inputs.add(new RecipeInput(this.getInput2().getItemsStack(), null));
        return inputs;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        List<FeatureInterface> features = super.getFeatures();
        if (this.mergeType.getValue().get() == AnvilMergeType.INPUT1_AS_RESULT || this.mergeType.getValue().get() == AnvilMergeType.INPUT2_AS_RESULT) {
            features.remove(this.getResult());
        }
        features.add((FeatureInterface)this.mergeType);
        features.add((FeatureInterface)this.input1);
        features.add((FeatureInterface)this.input2);
        features.add((FeatureInterface)this.itemCommandFeature);
        return features;
    }

    @Override
    public Map<FeatureInterface, Integer> getFeaturesMappingEditor() {
        Map<FeatureInterface, Integer> features = super.getFeaturesMappingEditor();
        if (this.mergeType.getValue().get() == AnvilMergeType.INPUT1_AS_RESULT) {
            features.remove(this.getResult());
        }
        features.put((FeatureInterface)this.mergeType, 18);
        features.put((FeatureInterface)this.itemCommandFeature, 27);
        features.put((FeatureInterface)this.input1, 29);
        features.put((FeatureInterface)this.input2, 31);
        return features;
    }

    @Override
    public void reload() {
        super.reload();
        SsomarDev.testMsg((String)("Reloading Anvil recipe > " + this.getParent().hashCode() + " >> " + this.getParent().getClass()), (boolean)true);
        if (this.getParent() instanceof RecipeAnvil) {
            RecipeAnvil recipe = (RecipeAnvil)this.getParent();
            recipe.setMergeType(this.mergeType);
            recipe.setInput1(this.input1);
            recipe.setInput2(this.input2);
            recipe.setItemCommandFeature(this.itemCommandFeature);
        }
    }

    @Generated
    public EnumFeature<AnvilMergeType> getMergeType() {
        return this.mergeType;
    }

    @Generated
    public ItemStackFeature getInput1() {
        return this.input1;
    }

    @Generated
    public ItemStackFeature getInput2() {
        return this.input2;
    }

    @Generated
    public ItemCommandsFeature getItemCommandFeature() {
        return this.itemCommandFeature;
    }

    @Generated
    public void setMergeType(EnumFeature<AnvilMergeType> mergeType) {
        this.mergeType = mergeType;
    }

    @Generated
    public void setInput1(ItemStackFeature input1) {
        this.input1 = input1;
    }

    @Generated
    public void setInput2(ItemStackFeature input2) {
        this.input2 = input2;
    }

    @Generated
    public void setItemCommandFeature(ItemCommandsFeature itemCommandFeature) {
        this.itemCommandFeature = itemCommandFeature;
    }
}

