/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.click.controller;

import dev.triumphteam.gui.click.controller.ClickController;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultClickController
implements ClickController {
    private final CompletableFuture<Boolean> deferred = new CompletableFuture();
    private boolean completingLater = false;

    public DefaultClickController(@NotNull BiConsumer<Boolean, ? super Throwable> onComplete) {
        this.deferred.whenComplete(onComplete);
    }

    @Override
    public boolean isDone() {
        return this.deferred.isDone() || this.deferred.isCancelled();
    }

    @Override
    public void complete(@Nullable Throwable throwable) {
        if (this.isDone()) {
            return;
        }
        if (throwable != null) {
            this.deferred.completeExceptionally(throwable);
            return;
        }
        this.deferred.complete(true);
    }

    @Override
    public boolean completingLater() {
        return this.completingLater;
    }

    @Override
    public void completingLater(boolean value) {
        this.completingLater = value;
    }
}

