/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.bukkit;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.bukkit.BukkitSubCommand;
import org.nay.cmd.bukkit.BukkitSubCommandProcessor;
import org.nay.cmd.bukkit.CommandPermission;
import org.nay.cmd.bukkit.annotation.Permission;
import org.nay.cmd.core.BaseCommand;
import org.nay.cmd.core.execution.ExecutionProvider;
import org.nay.cmd.core.processor.AbstractCommandProcessor;
import org.nay.cmd.core.registry.RegistryContainer;
import org.nay.cmd.core.sender.SenderMapper;
import org.nay.cmd.core.sender.SenderValidator;

final class BukkitCommandProcessor<S>
extends AbstractCommandProcessor<CommandSender, S, BukkitSubCommand<S>, BukkitSubCommandProcessor<S>> {
    private final CommandPermission basePermission;

    public BukkitCommandProcessor(@NotNull BaseCommand baseCommand, @NotNull RegistryContainer<S> registryContainer, @NotNull SenderMapper<CommandSender, S> senderMapper, @NotNull SenderValidator<S> senderValidator, @NotNull ExecutionProvider syncExecutionProvider, @NotNull ExecutionProvider asyncExecutionProvider, @Nullable CommandPermission globalBasePermission) {
        super(baseCommand, registryContainer, senderMapper, senderValidator, syncExecutionProvider, asyncExecutionProvider);
        Permission annotation = this.getBaseCommand().getClass().getAnnotation(Permission.class);
        if (annotation == null) {
            this.basePermission = null;
            return;
        }
        this.basePermission = BukkitCommandProcessor.createPermission(globalBasePermission, Arrays.stream(annotation.value()).collect(Collectors.toList()), annotation.description(), annotation.def());
    }

    @Override
    @NotNull
    protected BukkitSubCommandProcessor<S> createProcessor(@NotNull Method method) {
        return new BukkitSubCommandProcessor(this.getBaseCommand(), this.getName(), method, this.getRegistryContainer(), this.getSenderValidator(), this.basePermission);
    }

    @Override
    @NotNull
    protected BukkitSubCommand<S> createSubCommand(@NotNull BukkitSubCommandProcessor<S> processor, @NotNull ExecutionProvider executionProvider) {
        return new BukkitSubCommand<S>(processor, this.getName(), executionProvider);
    }

    static CommandPermission createPermission(@Nullable CommandPermission parent, @NotNull @NotNull List<@NotNull String> nodes, @NotNull String description, @NotNull PermissionDefault permissionDefault) {
        return parent == null ? new CommandPermission(nodes, description, permissionDefault) : parent.child(nodes, description, permissionDefault);
    }
}

