/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.bukkit;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nay.cmd.bukkit.message.BukkitMessageKey;
import org.nay.cmd.core.SubCommand;
import org.nay.cmd.core.message.MessageRegistry;
import org.nay.cmd.core.message.context.DefaultMessageContext;
import org.nay.cmd.core.sender.SenderValidator;

class BukkitSenderValidator
implements SenderValidator<CommandSender> {
    BukkitSenderValidator() {
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Class<? extends @NotNull CommandSender>> getAllowedSenders() {
        return ImmutableSet.of(CommandSender.class, ConsoleCommandSender.class, Player.class);
    }

    @Override
    public boolean validate(@NotNull MessageRegistry<CommandSender> messageRegistry, @NotNull SubCommand<CommandSender> subCommand, @NotNull CommandSender sender) {
        Class<CommandSender> senderClass = subCommand.getSenderType();
        if (Player.class.isAssignableFrom(senderClass) && !(sender instanceof Player)) {
            messageRegistry.sendMessage(BukkitMessageKey.PLAYER_ONLY, sender, new DefaultMessageContext(subCommand.getParentName(), subCommand.getName()));
            return false;
        }
        if (ConsoleCommandSender.class.isAssignableFrom(senderClass) && !(sender instanceof ConsoleCommandSender)) {
            messageRegistry.sendMessage(BukkitMessageKey.CONSOLE_ONLY, sender, new DefaultMessageContext(subCommand.getParentName(), subCommand.getName()));
            return false;
        }
        return true;
    }
}

