/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.bukkit;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.bukkit.BukkitCommandProcessor;
import org.nay.cmd.bukkit.CommandPermission;
import org.nay.cmd.bukkit.annotation.Permission;
import org.nay.cmd.core.BaseCommand;
import org.nay.cmd.core.processor.AbstractSubCommandProcessor;
import org.nay.cmd.core.registry.RegistryContainer;
import org.nay.cmd.core.sender.SenderValidator;

final class BukkitSubCommandProcessor<S>
extends AbstractSubCommandProcessor<S> {
    private final CommandPermission permission;

    public BukkitSubCommandProcessor(@NotNull BaseCommand baseCommand, @NotNull String parentName, @NotNull Method method, @NotNull RegistryContainer<S> registryContainer, @NotNull SenderValidator<S> senderValidator, @Nullable CommandPermission basePermission) {
        super(baseCommand, parentName, method, registryContainer, senderValidator);
        Permission annotation = method.getAnnotation(Permission.class);
        if (annotation == null) {
            this.permission = basePermission;
            return;
        }
        this.permission = BukkitCommandProcessor.createPermission(basePermission, Arrays.stream(annotation.value()).collect(Collectors.toList()), annotation.description(), annotation.def());
    }

    @Nullable
    public CommandPermission getPermission() {
        return this.permission;
    }
}

