/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.bukkit;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandPermission {
    private final List<String> nodes;
    private final PermissionDefault permissionDefault;
    private final String description;

    public CommandPermission(@NotNull @NotNull List<@NotNull String> nodes, @NotNull String description, @NotNull PermissionDefault permissionDefault) {
        this.nodes = nodes;
        this.description = description;
        this.permissionDefault = permissionDefault;
    }

    public static boolean hasPermission(@NotNull CommandSender sender, @Nullable CommandPermission permission) {
        return permission == null || permission.hasPermission(sender);
    }

    @NotNull
    public CommandPermission child(@NotNull @NotNull List<@NotNull String> nodes, @NotNull String description, @NotNull PermissionDefault permissionDefault) {
        List<String> newNodes = this.nodes.stream().flatMap(parent -> nodes.stream().map(node -> parent + "." + node)).collect(Collectors.toList());
        return new CommandPermission(newNodes, description, permissionDefault);
    }

    public void register() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.nodes.forEach(node -> {
            Permission permission = pluginManager.getPermission(node);
            if (permission != null) {
                return;
            }
            pluginManager.addPermission(new Permission(node, this.description, this.permissionDefault));
        });
    }

    @NotNull
    public @NotNull List<@NotNull String> getNodes() {
        return this.nodes;
    }

    public boolean hasPermission(@NotNull CommandSender sender) {
        return this.nodes.stream().anyMatch(arg_0 -> ((CommandSender)sender).hasPermission(arg_0));
    }
}

