/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.nay.cmd.core.BaseCommand;
import org.nay.cmd.core.argument.ArgumentResolver;
import org.nay.cmd.core.argument.named.Argument;
import org.nay.cmd.core.argument.named.ArgumentKey;
import org.nay.cmd.core.message.ContextualKey;
import org.nay.cmd.core.message.MessageResolver;
import org.nay.cmd.core.message.context.MessageContext;
import org.nay.cmd.core.registry.RegistryContainer;
import org.nay.cmd.core.requirement.RequirementKey;
import org.nay.cmd.core.requirement.RequirementResolver;
import org.nay.cmd.core.sender.SenderMapper;
import org.nay.cmd.core.sender.SenderValidator;
import org.nay.cmd.core.suggestion.SuggestionKey;
import org.nay.cmd.core.suggestion.SuggestionResolver;

public abstract class CommandManager<DS, S> {
    private final SenderMapper<DS, S> senderMapper;
    private final SenderValidator<S> senderValidator;

    public CommandManager(@NotNull SenderMapper<DS, S> senderMapper, @NotNull SenderValidator<S> senderValidator) {
        this.senderMapper = senderMapper;
        this.senderValidator = senderValidator;
    }

    public abstract void registerCommand(@NotNull BaseCommand var1);

    public final void registerCommand(BaseCommand ... baseCommands) {
        for (BaseCommand command : baseCommands) {
            this.registerCommand(command);
        }
    }

    public abstract void unregisterCommand(@NotNull BaseCommand var1);

    public final void unregisterCommands(BaseCommand ... commands) {
        for (BaseCommand command : commands) {
            this.unregisterCommand(command);
        }
    }

    public final void registerArgument(@NotNull Class<?> clazz, @NotNull ArgumentResolver<S> resolver) {
        this.getRegistryContainer().getArgumentRegistry().register(clazz, resolver);
    }

    public void registerSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S> suggestionResolver) {
        this.getRegistryContainer().getSuggestionRegistry().register(key, suggestionResolver);
    }

    public void registerSuggestion(@NotNull Class<?> type, @NotNull SuggestionResolver<S> suggestionResolver) {
        this.getRegistryContainer().getSuggestionRegistry().register(type, suggestionResolver);
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, Argument ... arguments) {
        this.registerNamedArguments(key, Arrays.asList(arguments));
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, @NotNull @NotNull List<@NotNull Argument> arguments) {
        this.getRegistryContainer().getNamedArgumentRegistry().register(key, arguments);
    }

    public final <C extends MessageContext> void registerMessage(@NotNull ContextualKey<C> key, @NotNull MessageResolver<S, C> resolver) {
        this.getRegistryContainer().getMessageRegistry().register(key, resolver);
    }

    public final void registerRequirement(@NotNull RequirementKey key, @NotNull RequirementResolver<S> resolver) {
        this.getRegistryContainer().getRequirementRegistry().register(key, resolver);
    }

    @NotNull
    protected abstract RegistryContainer<S> getRegistryContainer();

    @NotNull
    protected SenderMapper<DS, S> getSenderMapper() {
        return this.senderMapper;
    }

    @NotNull
    protected SenderValidator<S> getSenderValidator() {
        return this.senderValidator;
    }
}

