/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.argument;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.argument.InternalArgument;
import org.nay.cmd.core.argument.LimitlessInternalArgument;
import org.nay.cmd.core.suggestion.Suggestion;

public final class CollectionInternalArgument<S>
extends LimitlessInternalArgument<S> {
    private final InternalArgument<S, String> internalArgument;
    private final Class<?> collectionType;

    public CollectionInternalArgument(@NotNull String name, @NotNull String description, @NotNull InternalArgument<S, String> internalArgument, @NotNull Class<?> collectionType, @NotNull Suggestion<S> suggestion, int position, boolean optional) {
        super(name, description, String.class, suggestion, position, optional);
        this.internalArgument = internalArgument;
        this.collectionType = collectionType;
    }

    @Override
    @NotNull
    public Object resolve(@NotNull S sender, @NotNull @NotNull List<@NotNull String> value) {
        Stream<Object> stream = value.stream().map(arg -> this.internalArgument.resolve(sender, (String)arg));
        if (this.collectionType == Set.class) {
            return stream.collect(Collectors.toSet());
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollectionInternalArgument that = (CollectionInternalArgument)o;
        return this.collectionType.equals(that.collectionType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.collectionType);
    }

    @Override
    @NotNull
    public String toString() {
        return "CollectionArgument{collectionType=" + this.collectionType + ", super=" + super.toString() + "}";
    }
}

