/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.argument;

import java.lang.ref.WeakReference;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.argument.StringInternalArgument;
import org.nay.cmd.core.suggestion.Suggestion;
import org.nay.cmd.core.util.EnumUtils;

public final class EnumInternalArgument<S>
extends StringInternalArgument<S> {
    private final Class<? extends Enum<?>> enumType;

    public EnumInternalArgument(@NotNull String name, @NotNull String description, @NotNull Class<? extends Enum<?>> type, @NotNull Suggestion<S> suggestion, int position, boolean optional) {
        super(name, description, type, suggestion, position, optional);
        this.enumType = type;
        EnumUtils.populateCache(type);
    }

    @NotNull
    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    @Override
    @Nullable
    public Object resolve(@NotNull S sender, @NotNull String value) {
        WeakReference<Enum<?>> reference = EnumUtils.getEnumConstants(this.enumType).get(value.toUpperCase());
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumInternalArgument that = (EnumInternalArgument)o;
        return this.enumType.equals(that.enumType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enumType);
    }

    @Override
    @NotNull
    public String toString() {
        return "EnumArgument{enumType=" + this.enumType + ", super=" + super.toString() + "}";
    }
}

