/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.argument;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.argument.LimitlessInternalArgument;
import org.nay.cmd.core.suggestion.Suggestion;

public final class JoinedStringInternalArgument<S>
extends LimitlessInternalArgument<S> {
    private final CharSequence delimiter;

    public JoinedStringInternalArgument(@NotNull String name, @NotNull String description, @NotNull CharSequence delimiter, @NotNull Suggestion<S> suggestion, int position, boolean optional) {
        super(name, description, String.class, suggestion, position, optional);
        this.delimiter = delimiter;
    }

    @Override
    @NotNull
    public Object resolve(@NotNull S sender, @NotNull @NotNull List<@NotNull String> value) {
        return String.join(this.delimiter, value);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JoinedStringInternalArgument that = (JoinedStringInternalArgument)o;
        return this.delimiter.equals(that.delimiter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delimiter);
    }

    @Override
    @NotNull
    public String toString() {
        return "JoinedStringArgument{delimiter=" + this.delimiter + ", super=" + super.toString() + "}";
    }
}

