/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.argument.named;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.argument.named.Argument;
import org.nay.cmd.core.argument.named.SimpleArgument;
import org.nay.cmd.core.exceptions.CommandRegistrationException;
import org.nay.cmd.core.suggestion.SuggestionKey;

abstract class AbstractArgumentBuilder<T extends AbstractArgumentBuilder<T>> {
    private final Class<?> type;
    private String name;
    private String description = "Description!";
    private SuggestionKey suggestionKey;

    public AbstractArgumentBuilder(@NotNull Class<?> type) {
        this.type = type;
    }

    @Contract(value="_ -> this")
    @NotNull
    public T name(@NotNull String name) {
        this.name = name;
        return (T)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public T description(@NotNull String description) {
        this.description = description;
        return (T)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public T suggestion(@NotNull SuggestionKey suggestionKey) {
        this.suggestionKey = suggestionKey;
        return (T)this;
    }

    @Contract(value=" -> new")
    @NotNull
    public Argument build() {
        return new SimpleArgument(this);
    }

    @NotNull
    Class<?> getType() {
        return this.type;
    }

    @NotNull
    String getName() {
        if (this.name == null || this.name.isEmpty()) {
            throw new CommandRegistrationException("Argument is missing a name!");
        }
        return this.name;
    }

    @NotNull
    String getDescription() {
        return this.description;
    }

    @Nullable
    SuggestionKey getSuggestionKey() {
        return this.suggestionKey;
    }
}

