/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.argument.named;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.nay.cmd.core.argument.named.AbstractArgumentBuilder;
import org.nay.cmd.core.argument.named.Argument;
import org.nay.cmd.core.argument.named.ListArgument;

public final class ListArgumentBuilder
extends AbstractArgumentBuilder<ListArgumentBuilder> {
    private final Class<?> collectionType;
    private String separator = ",";

    public ListArgumentBuilder(@NotNull Class<?> collectionType, @NotNull Class<?> type) {
        super(type);
        this.collectionType = collectionType;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ListArgumentBuilder separator(@NotNull String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    @Contract(value=" -> new")
    @NotNull
    public Argument build() {
        return new ListArgument(this);
    }

    @NotNull
    Class<?> getCollectionType() {
        return this.collectionType;
    }

    @NotNull
    String getSeparator() {
        return this.separator;
    }
}

