/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.flag.internal;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.argument.StringInternalArgument;
import org.nay.cmd.core.exceptions.CommandExecutionException;

public final class FlagOptions<S> {
    private final String flag;
    private final String longFlag;
    private final StringInternalArgument<S> argument;

    public FlagOptions(@Nullable String flag, @Nullable String longFlag, @Nullable StringInternalArgument<S> argument) {
        this.flag = flag;
        this.longFlag = longFlag;
        this.argument = argument;
    }

    @Nullable
    public String getFlag() {
        return this.flag;
    }

    @Nullable
    public String getLongFlag() {
        return this.longFlag;
    }

    @Nullable
    public StringInternalArgument<S> getArgument() {
        return this.argument;
    }

    @NotNull
    public String getKey() {
        if (this.flag == null && this.longFlag == null) {
            throw new CommandExecutionException("Both options can't be null.");
        }
        return this.flag == null ? this.longFlag : this.flag;
    }

    public boolean hasArgument() {
        return this.argument != null;
    }
}

