/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.flag.internal;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.nay.cmd.core.flag.Flags;
import org.nay.cmd.core.flag.internal.FlagGroup;
import org.nay.cmd.core.flag.internal.FlagOptions;
import org.nay.cmd.core.flag.internal.FlagScanner;
import org.nay.cmd.core.flag.internal.FlagsResult;

public final class FlagParser<S> {
    private final FlagGroup<S> flagGroup;
    private static final String ESCAPE = "\\";
    private static final String LONG = "--";
    private static final String SHORT = "-";
    private static final int EQUALS = 61;
    private List<String> hi;

    public FlagParser(@NotNull FlagGroup<S> flagGroup) {
        this.flagGroup = flagGroup;
    }

    @NotNull
    public @NotNull Map<@NotNull FlagOptions<S>, @NotNull String> parseFlags(@NotNull @NotNull List<@NotNull String> toParse) {
        return this.parseInternal(toParse).getKey();
    }

    @NotNull
    public Flags parse(@NotNull S sender, @NotNull @NotNull List<@NotNull String> toParse) {
        Map.Entry<Map<FlagOptions<S>, String>, List<String>> parsed = this.parseInternal(toParse);
        return new FlagsResult<S>(sender, parsed.getKey(), parsed.getValue());
    }

    private @NotNull Map.Entry<@NotNull Map<@NotNull FlagOptions<S>, @NotNull String>, @NotNull List<@NotNull String>> parseInternal(@NotNull @NotNull List<@NotNull String> toParse) {
        FlagScanner tokens = new FlagScanner(toParse);
        LinkedHashMap<FlagOptions<S>, String> flags = new LinkedHashMap<FlagOptions<S>, String>();
        ArrayList<String> args = new ArrayList<String>();
        while (tokens.hasNext()) {
            String token = tokens.next();
            if (token.startsWith(ESCAPE)) {
                args.add(token);
                continue;
            }
            if (!(token.startsWith(LONG) && !LONG.equals(token) || token.startsWith(SHORT) && !SHORT.equals(token))) {
                args.add(token);
                continue;
            }
            int equals = token.indexOf(61);
            if (equals == -1) {
                FlagOptions<S> flag = this.flagGroup.getMatchingFlag(token);
                if (flag == null) {
                    args.add(token);
                    continue;
                }
                if (flag.hasArgument()) {
                    if (!tokens.hasNext()) {
                        flags.put(flag, "");
                        continue;
                    }
                    flags.put(flag, tokens.next());
                    continue;
                }
                flags.put(flag, null);
                continue;
            }
            String flagToken = token.substring(0, equals);
            String argToken = token.substring(equals + 1);
            FlagOptions<S> flag = this.flagGroup.getMatchingFlag(flagToken);
            if (flag == null) {
                args.add(token);
                continue;
            }
            if (!flag.hasArgument()) {
                args.add(token);
                continue;
            }
            flags.put(flag, argToken);
        }
        return Maps.immutableEntry(flags, args);
    }
}

