/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.flag.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.flag.Flags;
import org.nay.cmd.core.flag.internal.ArgFlagValue;
import org.nay.cmd.core.flag.internal.EmptyFlagValue;
import org.nay.cmd.core.flag.internal.FlagOptions;
import org.nay.cmd.core.flag.internal.FlagValue;

class FlagsResult<S>
implements Flags {
    private final Map<String, FlagValue> flags = new HashMap<String, FlagValue>();
    private final List<String> args;
    private final S sender;

    FlagsResult(@NotNull S sender, @NotNull @NotNull Map<@NotNull FlagOptions<S>, @NotNull String> flags, @NotNull @NotNull List<@NotNull String> args) {
        this.sender = sender;
        flags.forEach(this::addFlag);
        this.args = args;
    }

    void addFlag(@NotNull FlagOptions<S> flag, @Nullable String value) {
        FlagValue flagValue;
        String shortFlag = flag.getFlag();
        String longFlag = flag.getLongFlag();
        FlagValue flagValue2 = flagValue = value == null ? EmptyFlagValue.INSTANCE : new ArgFlagValue<S>(value, flag.getArgument());
        if (shortFlag != null) {
            this.flags.put(shortFlag, flagValue);
        }
        if (longFlag != null) {
            this.flags.put(longFlag, flagValue);
        }
    }

    void addArg(@NotNull String arg) {
        this.args.add(arg);
    }

    @Override
    public boolean hasFlag(@NotNull String flag) {
        return this.flags.containsKey(flag);
    }

    @Override
    @NotNull
    public <T> Optional<T> getValue(@NotNull String flag, @NotNull Class<T> type) {
        FlagValue flagValue = this.flags.get(flag);
        if (flagValue == null) {
            return Optional.empty();
        }
        if (!(flagValue instanceof ArgFlagValue)) {
            return Optional.empty();
        }
        ArgFlagValue argFlagValue = (ArgFlagValue)flagValue;
        return Optional.ofNullable(argFlagValue.getValue(this.sender, type));
    }

    @Override
    @NotNull
    public Optional<String> getValue(@NotNull String flag) {
        FlagValue flagValue = this.flags.get(flag);
        if (flagValue == null) {
            return Optional.empty();
        }
        if (!(flagValue instanceof ArgFlagValue)) {
            return Optional.empty();
        }
        ArgFlagValue argFlagValue = (ArgFlagValue)flagValue;
        return Optional.of(argFlagValue.getAsString());
    }

    @Override
    @NotNull
    public String getText() {
        return this.getText(" ");
    }

    @Override
    @NotNull
    public String getText(@NotNull String delimiter) {
        return String.join((CharSequence)delimiter, this.args);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }
}

