/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.message.context;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.message.context.AbstractMessageContext;

public final class InvalidArgumentContext
extends AbstractMessageContext {
    private final String argument;
    private final String name;
    private final Class<?> type;

    public InvalidArgumentContext(@NotNull String command, @NotNull String subCommand, @NotNull String argument, @NotNull String name, @NotNull Class<?> type) {
        super(command, subCommand);
        this.argument = argument;
        this.name = name;
        this.type = type;
    }

    @NotNull
    public String getTypedArgument() {
        return this.argument;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Class<?> getArgumentType() {
        return this.type;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvalidArgumentContext that = (InvalidArgumentContext)o;
        return this.argument.equals(that.argument) && this.name.equals(that.name) && this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.argument, this.name, this.type);
    }

    @Override
    @NotNull
    public String toString() {
        return "InvalidArgumentContext{argument='" + this.argument + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + ", super=" + super.toString() + "}";
    }
}

