/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.suggestion;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.suggestion.Suggestion;
import org.nay.cmd.core.suggestion.SuggestionContext;
import org.nay.cmd.core.util.EnumUtils;

public final class EnumSuggestion<S>
implements Suggestion<S> {
    private final Class<? extends Enum<?>> enumType;

    public EnumSuggestion(@NotNull Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
        EnumUtils.populateCache(enumType);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull String> getSuggestions(@NotNull S sender, @NotNull String current, @NotNull SuggestionContext context) {
        return EnumUtils.getEnumConstants(this.enumType).values().stream().map(it -> {
            Enum constant = (Enum)it.get();
            if (constant == null) {
                return null;
            }
            return constant.name();
        }).filter(Objects::nonNull).filter(it -> it.toLowerCase().startsWith(current.toLowerCase())).collect(Collectors.toList());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumSuggestion that = (EnumSuggestion)o;
        return this.enumType.equals(that.enumType);
    }

    public int hashCode() {
        return Objects.hash(this.enumType);
    }

    @NotNull
    public String toString() {
        return "EnumSuggestion{enumType=" + this.enumType + '}';
    }
}

