/*
 * Decompiled with CFR 0.152.
 */
package org.nay.cmd.core.suggestion;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nay.cmd.core.registry.Registry;
import org.nay.cmd.core.suggestion.SuggestionKey;
import org.nay.cmd.core.suggestion.SuggestionResolver;

public final class SuggestionRegistry<S>
implements Registry {
    private final Map<SuggestionKey, SuggestionResolver<S>> suggestions = new HashMap<SuggestionKey, SuggestionResolver<S>>();
    private final Map<Class<?>, SuggestionResolver<S>> typeSuggestions = new HashMap();

    public void register(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S> resolver) {
        this.suggestions.put(key, resolver);
    }

    public void register(@NotNull Class<?> type, @NotNull SuggestionResolver<S> resolver) {
        this.typeSuggestions.put(type, resolver);
    }

    @Contract(value="null -> null")
    @Nullable
    public SuggestionResolver<S> getSuggestionResolver(@Nullable SuggestionKey key) {
        if (key == null) {
            return null;
        }
        return this.suggestions.get(key);
    }

    @Nullable
    public SuggestionResolver<S> getSuggestionResolver(@NotNull Class<?> type) {
        return this.typeSuggestions.get(type);
    }
}

