/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.nay.cmd.bukkit.BukkitCommandManager;
import org.nay.cmd.bukkit.message.BukkitMessageKey;
import org.nay.cmd.core.BaseCommand;
import org.nay.scalespawn.commands.ScaleSpawnCommand;
import org.nay.scalespawn.listener.CreatureDeathListener;
import org.nay.scalespawn.listener.CreatureSpawnListener;
import org.nay.scalespawn.listener.chunks.ChunkLoadListener;
import org.nay.scalespawn.managers.ScaleManager;
import org.nay.scalespawn.utils.Colorize;

public final class ScaleSpawn
extends JavaPlugin {
    public Set<String> allowedWorlds;
    public Set<String> allowedEntities;
    public Set<CreatureSpawnEvent.SpawnReason> spawnReasons;
    public boolean scaleAllReasons;
    public double spawnScaledProbability;
    public boolean scaleOnlyFromList;
    public double minScale;
    public double maxScale;
    public Random random;
    public boolean lifePerScale;
    public double maxHealthScale;
    public boolean damagePerScale;
    public double maxDamageScale;
    public boolean speedPerScale;
    public double maxSpeedScale;
    public boolean adjustsDrops;
    public double negativeDropMultiplier;
    public double positiveDropMultiplier;
    public boolean processEntitiesOnLoadNewChunks;
    public boolean customDrops;
    public ScaleManager scaleManager;
    public double version = 1.0;

    public void onEnable() {
        this.setupConfiguration();
        this.setupConfigValues();
        this.scaleManager = new ScaleManager(this);
        this.registerListeners();
        this.setupCommands();
        this.version = this.getConfig().getDouble("version", 1.0);
        this.getLogger().info("[i] ScaleSpawn enabled > " + this.version);
        this.random = new Random();
    }

    public void setupConfiguration() {
        File config = new File(this.getDataFolder(), "config.yml");
        if (!config.exists()) {
            this.getConfig().options().copyDefaults(true);
            this.saveConfig();
        }
    }

    public void setupCommands() {
        BukkitCommandManager<CommandSender> manager = BukkitCommandManager.create((Plugin)this);
        manager.registerCommand((BaseCommand)new ScaleSpawnCommand(this));
        manager.registerMessage(BukkitMessageKey.NO_PERMISSION, (sender, context) -> sender.sendMessage(Colorize.Color(this.getConfig().getString("Messages.no-permission"))));
    }

    public void registerListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new CreatureDeathListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new CreatureSpawnListener(this), (Plugin)this);
        if (this.getConfig().getBoolean("allow-chunk-load-listener")) {
            pluginManager.registerEvents((Listener)new ChunkLoadListener(this), (Plugin)this);
        }
    }

    public void setupConfigValues() {
        FileConfiguration config = this.getConfig();
        this.allowedWorlds = new HashSet<String>(config.getStringList("Spawn.allowed-worlds"));
        this.allowedEntities = new HashSet<String>(config.getStringList("Spawn.scale-list"));
        this.scaleOnlyFromList = config.getBoolean("Spawn.scale-only-from-list");
        this.spawnScaledProbability = config.getDouble("Spawn.spawn-scaled-probability");
        this.scaleAllReasons = config.getBoolean("Spawn.scale-all-reasons");
        this.spawnScaledProbability = config.getDouble("Spawn.spawn-scaled-probability");
        this.minScale = config.getDouble("Scale.min-scale");
        this.maxScale = config.getDouble("Scale.max-scale");
        this.lifePerScale = config.getBoolean("Scale.life-per-scale");
        this.maxHealthScale = config.getDouble("Scale.max-health-scale");
        this.damagePerScale = config.getBoolean("Scale.damage-per-scale");
        this.maxDamageScale = config.getDouble("Scale.max-damage-scale");
        this.speedPerScale = config.getBoolean("Scale.speed-per-scale");
        this.maxSpeedScale = config.getDouble("Scale.max-speed-scale");
        this.adjustsDrops = config.getBoolean("Drops.adjusts-drops");
        this.negativeDropMultiplier = config.getDouble("Drops.negative-drop-multiplier");
        this.positiveDropMultiplier = config.getDouble("Drops.positive-drop-multiplier");
        this.customDrops = config.getBoolean("Drops.custom-drops");
        this.customDrops = config.getBoolean("Drops.custom-drops");
        this.processEntitiesOnLoadNewChunks = config.getBoolean("Spawn.process-entities-on-load-new-chunks");
        this.spawnReasons = new HashSet<CreatureSpawnEvent.SpawnReason>();
        List reasons = config.getStringList("Spawn.scale-spawn-reason");
        for (String reason : reasons) {
            try {
                this.spawnReasons.add(CreatureSpawnEvent.SpawnReason.valueOf((String)reason.toUpperCase()));
                this.getLogger().info("[i] Loaded SpawnReason: " + reason);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("[i] Invalid SpawnReason in config: " + reason);
            }
        }
    }
}

