/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn.listener;

import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.nay.scalespawn.ScaleSpawn;

public class CreatureDeathListener
implements Listener {
    private ScaleSpawn scaleSpawn;

    public CreatureDeathListener(ScaleSpawn scaleSpawn) {
        this.scaleSpawn = scaleSpawn;
    }

    @EventHandler
    public void creatureDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        String worldName = entity.getWorld().getName();
        if (entity instanceof Player) {
            return;
        }
        if (!this.scaleSpawn.allowedWorlds.contains(worldName)) {
            return;
        }
        if (this.scaleSpawn.scaleOnlyFromList && !this.scaleSpawn.allowedEntities.contains(entity.getName().toUpperCase())) {
            return;
        }
        if (!this.scaleSpawn.adjustsDrops) {
            return;
        }
        ConfigurationSection entityConfig = this.scaleSpawn.getConfig().getConfigurationSection("Drops.drops." + entity.getType().toString().toUpperCase());
        if (entityConfig == null) {
            return;
        }
        if (this.scaleSpawn.adjustsDrops) {
            this.scaleSpawn.scaleManager.adjustDropsAmount(entity, entityConfig, event);
        }
        if (this.scaleSpawn.customDrops) {
            this.scaleSpawn.scaleManager.applyCustomDrops(entityConfig, event);
        }
    }
}

