/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn.listener;

import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.nay.scalespawn.ScaleSpawn;
import org.nay.scalespawn.managers.attributes.AttributeManager;

public class CreatureSpawnListener
implements Listener {
    private ScaleSpawn scaleSpawn;

    public CreatureSpawnListener(ScaleSpawn scaleSpawn) {
        this.scaleSpawn = scaleSpawn;
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        CreatureSpawnEvent.SpawnReason spawnReason = event.getSpawnReason();
        String worldName = entity.getWorld().getName();
        if (!this.scaleSpawn.allowedWorlds.contains(worldName)) {
            return;
        }
        if (!this.scaleSpawn.scaleAllReasons && !this.scaleSpawn.spawnReasons.contains(spawnReason)) {
            return;
        }
        if (this.scaleSpawn.scaleOnlyFromList && !this.scaleSpawn.allowedEntities.contains(entity.getName().toUpperCase())) {
            return;
        }
        if (Math.random() > this.scaleSpawn.spawnScaledProbability) {
            return;
        }
        try {
            if (AttributeManager.processAttributes(entity, this.scaleSpawn)) {
                return;
            }
        }
        catch (Exception ex) {
            this.scaleSpawn.getLogger().info("An error occured while getting scale for " + entity.getName());
            this.scaleSpawn.getLogger().info(ex.toString());
        }
    }
}

