/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn.listener.chunks;

import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.nay.scalespawn.ScaleSpawn;
import org.nay.scalespawn.managers.attributes.AttributeManager;

public class ChunkLoadListener
implements Listener {
    private ScaleSpawn scaleSpawn;

    public ChunkLoadListener(ScaleSpawn scaleSpawn) {
        this.scaleSpawn = scaleSpawn;
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        String worldName = chunk.getWorld().getName();
        if (!this.scaleSpawn.processEntitiesOnLoadNewChunks) {
            return;
        }
        if (!this.scaleSpawn.allowedWorlds.contains(worldName)) {
            return;
        }
        if (!event.isNewChunk()) {
            return;
        }
        if (Math.random() > 0.1) {
            return;
        }
        for (Entity entity : chunk.getEntities()) {
            if (Math.random() > this.scaleSpawn.spawnScaledProbability) {
                return;
            }
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            if (this.scaleSpawn.scaleOnlyFromList && !this.scaleSpawn.allowedEntities.contains(entity.getName().toUpperCase())) {
                return;
            }
            try {
                LivingEntity ent = (LivingEntity)entity;
                if (!AttributeManager.processAttributes(ent, this.scaleSpawn)) continue;
                return;
            }
            catch (Exception ex) {
                this.scaleSpawn.getLogger().info("An error occured while getting scale for " + entity.getName());
                this.scaleSpawn.getLogger().info(ex.toString());
            }
        }
    }
}

