/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn.managers;

import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.nay.scalespawn.ScaleSpawn;

public class ScaleManager {
    private ScaleSpawn scaleSpawn;

    public ScaleManager(ScaleSpawn scaleSpawn) {
        this.scaleSpawn = scaleSpawn;
    }

    private boolean evaluteCondition(String condition, double entityScale) {
        try {
            String operator = condition.substring(0, 1);
            double threshold = Double.parseDouble(condition.substring(1));
            switch (operator) {
                case ">": {
                    return entityScale > threshold;
                }
                case "<": {
                    return entityScale < threshold;
                }
                case "=": {
                    return entityScale == threshold;
                }
            }
            return false;
        }
        catch (Exception ex) {
            this.scaleSpawn.getLogger().warning("Invalid scale condition: " + condition);
            return false;
        }
    }

    public void adjustDropsAmount(LivingEntity entity, ConfigurationSection entityConfig, EntityDeathEvent listener) {
        double dropMultiplier = 1.0;
        double scaleValue = Objects.requireNonNull(entity.getAttribute(Attribute.GENERIC_SCALE)).getValue();
        dropMultiplier = scaleValue >= 1.0 ? this.scaleSpawn.positiveDropMultiplier : this.scaleSpawn.negativeDropMultiplier;
        List drops = listener.getDrops();
        for (ItemStack drop : drops) {
            if (scaleValue > 1.0) {
                drop.setAmount((int)Math.ceil((double)drop.getAmount() * dropMultiplier) + (int)(dropMultiplier / 2.0));
                continue;
            }
            drop.setAmount((int)Math.ceil((double)drop.getAmount() * dropMultiplier));
        }
    }

    public void applyCustomDrops(ConfigurationSection entityConfig, EntityDeathEvent event) {
        List items = entityConfig.getStringList("items");
        if (items.isEmpty()) {
            return;
        }
        double scaleValue = Objects.requireNonNull(event.getEntity().getAttribute(Attribute.GENERIC_SCALE)).getValue();
        for (String itemString : items) {
            try {
                String scaleCondition;
                String[] parts = itemString.split(";");
                if (parts.length != 3) {
                    this.scaleSpawn.getLogger().warning("Invalid item format: " + itemString);
                }
                if (!this.evaluteCondition(scaleCondition = entityConfig.getString("scale"), scaleValue)) continue;
                double dropChance = Double.parseDouble(parts[2]);
                if (!(Math.random() < dropChance)) continue;
                ItemStack itemStack = new ItemStack(Material.valueOf((String)parts[0].toUpperCase()), Integer.parseInt(parts[1]));
                event.getDrops().add(itemStack);
            }
            catch (IllegalArgumentException e) {
                this.scaleSpawn.getLogger().warning("Invalid item: " + itemString);
            }
        }
    }
}

