/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn.managers.attributes;

import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.nay.scalespawn.ScaleSpawn;

public class AttributeManager {
    public static boolean processAttributes(LivingEntity ent, ScaleSpawn scaleSpawn) {
        double scale = scaleSpawn.minScale + (scaleSpawn.maxScale - scaleSpawn.minScale) * scaleSpawn.random.nextDouble();
        AttributeInstance scaleAttribute = ent.getAttribute(Attribute.GENERIC_SCALE);
        AttributeInstance speedAttribute = ent.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        AttributeInstance damageAttribute = ent.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        AttributeInstance healthAttribute = ent.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (scaleAttribute == null) {
            return true;
        }
        scaleAttribute.setBaseValue(scale);
        if (scaleSpawn.lifePerScale && healthAttribute != null) {
            double newHealth = Math.min(healthAttribute.getBaseValue() * scale, scaleSpawn.maxHealthScale);
            healthAttribute.setBaseValue(newHealth);
            ent.setHealth(ent.getMaxHealth());
        }
        if (scaleSpawn.speedPerScale && speedAttribute != null) {
            double newSpeed = Math.min(speedAttribute.getBaseValue() * scale, scaleSpawn.maxSpeedScale);
            speedAttribute.setBaseValue(newSpeed);
        }
        if (scaleSpawn.damagePerScale && damageAttribute != null) {
            double newDamage = Math.min(damageAttribute.getBaseValue() * scale, scaleSpawn.maxDamageScale);
            damageAttribute.setBaseValue(newDamage);
        }
        return false;
    }
}

