/*
 * Decompiled with CFR 0.152.
 */
package org.nay.scalespawn.menu;

import dev.triumphteam.gui.builder.gui.SimpleBuilder;
import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.nay.scalespawn.ScaleSpawn;
import org.nay.scalespawn.menu.BaseMenuCreator;
import org.nay.scalespawn.utils.Colorize;

public class ScaleMenu
implements BaseMenuCreator {
    private ScaleSpawn scaleSpawn;
    private static ScaleMenu instance;

    public ScaleMenu(ScaleSpawn scaleSpawn) {
        this.scaleSpawn = scaleSpawn;
    }

    public static ScaleMenu getInstance(ScaleSpawn plugin) {
        if (instance == null) {
            instance = new ScaleMenu(plugin);
        }
        return instance;
    }

    @Override
    public void open(Player player, Object ... objects) {
        Gui gui = (Gui)((SimpleBuilder)((SimpleBuilder)Gui.gui().title(Component.text("Scale Options"))).rows(3)).create().disableItemPlace().disableItemSwap().disableItemTake().disableOtherActions();
        GuiItem glass = ItemBuilder.from(Material.MAGENTA_STAINED_GLASS_PANE).asGuiItem();
        for (int i = 0; i <= 26; ++i) {
            gui.setItem(i, glass);
        }
        HashMap<String, Boolean> CHECKS = new HashMap<String, Boolean>();
        CHECKS.put("Spawn.scale-only-from-list", this.scaleSpawn.scaleOnlyFromList);
        CHECKS.put("Spawn.scale-all-reasons", this.scaleSpawn.scaleAllReasons);
        CHECKS.put("Spawn.life-per-scale", this.scaleSpawn.lifePerScale);
        CHECKS.put("Scale.damage-per-scale", this.scaleSpawn.damagePerScale);
        CHECKS.put("Scale.speed-per-scale", this.scaleSpawn.speedPerScale);
        CHECKS.put("Drops.adjusts-drops", this.scaleSpawn.adjustsDrops);
        CHECKS.put("Drops.custom-drops", this.scaleSpawn.customDrops);
        CHECKS.put("Spawn.process-entities-on-load-new-chunks", this.scaleSpawn.processEntitiesOnLoadNewChunks);
        int slot = 9;
        for (Map.Entry entry : CHECKS.entrySet()) {
            GuiItem checkItem = this.createCheckItem((String)entry.getKey(), (Boolean)entry.getValue());
            gui.setItem(slot, checkItem);
            if (++slot < gui.getInventory().getSize()) continue;
            break;
        }
        gui.open((HumanEntity)player);
    }

    private GuiItem createCheckItem(String checkName, boolean checkStatus) {
        FileConfiguration config = this.scaleSpawn.getConfig();
        ItemStack itemStack = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Colorize.Color("&d" + checkName).replaceAll("\\.", " "));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(Colorize.Color("&bStatus: " + (checkStatus ? "&aEnabled" : "&cDisabled")));
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return ItemBuilder.from(itemStack).asGuiItem(event -> {
            Player player = (Player)event.getWhoClicked();
            if (checkStatus) {
                config.set(checkName, (Object)false);
                player.sendMessage(Colorize.Color("&b&lScaleSpawn &f&l:: &b" + checkName + " disabled"));
            } else {
                config.set(checkName, (Object)true);
                player.sendMessage(Colorize.Color("&b&lScaleSpawn &f&l:: &b" + checkName + " enabled"));
            }
            this.scaleSpawn.saveConfig();
            this.scaleSpawn.reloadConfig();
            this.scaleSpawn.setupConfigValues();
            ScaleMenu.getInstance(this.scaleSpawn).open(player, new Object[0]);
        });
    }
}

