/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1308;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1355;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3483;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class MobBuffUtil {
    private static final class_2960 HEALTH_MODIFIER_ID = class_2960.method_60655((String)"buffmobs", (String)"temp_health");

    public static void applyBuffs(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.enabled || !MobBuffUtil.isValidMob(mob)) {
            return;
        }
        double dayMultiplier = MobBuffUtil.getDayMultiplier(mob.method_37908().method_8532());
        DimensionMultipliers dimMultipliers = MobBuffUtil.getDimensionMultipliers(mob);
        MobBuffUtil.applyAttributeModifiers(mob, dayMultiplier, dimMultipliers);
        MobBuffUtil.applyVanillaStatusEffects(mob);
        mob.method_6033(mob.method_6063());
    }

    public static double getDayMultiplier(long worldTime) {
        if (!BuffMobsMod.CONFIG.dayScaling.enabled) {
            return 1.0;
        }
        long days = worldTime / 24000L;
        long intervals = days / (long)BuffMobsMod.CONFIG.dayScaling.interval;
        double multiplier = 1.0 + (double)intervals * BuffMobsMod.CONFIG.dayScaling.multiplier;
        return Math.min(multiplier, BuffMobsMod.CONFIG.dayScaling.maxMultiplier);
    }

    public static DimensionMultipliers getDimensionMultipliers(class_1308 mob) {
        BuffMobsConfig.DimensionScaling.DimensionSlot[] slots;
        String dimensionName = mob.method_37908().method_27983().method_29177().toString();
        for (BuffMobsConfig.DimensionScaling.DimensionSlot slot : slots = new BuffMobsConfig.DimensionScaling.DimensionSlot[]{BuffMobsMod.CONFIG.dimensionScaling.slot1, BuffMobsMod.CONFIG.dimensionScaling.slot2, BuffMobsMod.CONFIG.dimensionScaling.slot3, BuffMobsMod.CONFIG.dimensionScaling.slot4, BuffMobsMod.CONFIG.dimensionScaling.slot5}) {
            if (slot.dimensionName.isEmpty() || !slot.dimensionName.equals(dimensionName)) continue;
            return new DimensionMultipliers((double)slot.healthMultiplier / 100.0, (double)slot.damageMultiplier / 100.0, (double)slot.speedMultiplier / 100.0, (double)slot.attackSpeedMultiplier / 100.0, slot.armorAddition, slot.armorToughnessAddition);
        }
        return new DimensionMultipliers(1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
    }

    public static void refreshInfiniteEffects(class_1308 mob) {
        if (BuffMobsMod.CONFIG.effects.duration != -1 || !MobBuffUtil.isValidMob(mob)) {
            return;
        }
        boolean showParticles = BuffMobsMod.CONFIG.visualEffects;
        int infiniteDuration = -1;
        MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5910, BuffMobsMod.CONFIG.effects.strengthAmplifier, infiniteDuration, showParticles);
        MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5907, BuffMobsMod.CONFIG.effects.resistanceAmplifier, infiniteDuration, showParticles);
        if (BuffMobsMod.CONFIG.effects.regenerationAmplifier > 0 && !mob.method_5864().method_20210(class_3483.field_46232)) {
            MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5924, BuffMobsMod.CONFIG.effects.regenerationAmplifier, infiniteDuration, showParticles);
        }
    }

    public static void applyPoisonToPlayer(class_1657 player, int duration) {
        player.method_6092(new class_1293(class_1294.field_5899, duration * 20, 0));
    }

    public static void applySlownessToPlayer(class_1657 player, int duration) {
        player.method_6092(new class_1293(class_1294.field_5909, duration * 20, 0));
    }

    public static void applyWitherToPlayer(class_1657 player, int duration) {
        player.method_6092(new class_1293(class_1294.field_5920, duration * 20, 0));
    }

    public static boolean isValidMob(class_1308 mob) {
        boolean isHostileOrNeutral;
        class_1321 tameable;
        if (mob instanceof class_1321 && (tameable = (class_1321)mob).method_6181()) {
            return false;
        }
        boolean bl = isHostileOrNeutral = mob instanceof class_1588 || mob.method_5864().method_20210(class_3483.field_19168) || MobBuffUtil.isNeutralMob(mob);
        if (!isHostileOrNeutral) {
            return false;
        }
        String mobId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        String modId = class_7923.field_41177.method_10221((Object)mob.method_5864()).method_12836();
        String dimensionName = mob.method_37908().method_27983().method_29177().toString();
        return MobBuffUtil.isValidDimension(dimensionName) && MobBuffUtil.isValidModId(modId) && MobBuffUtil.isValidMobId(mobId);
    }

    private static boolean isNeutralMob(class_1308 mob) {
        String mobId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        return mobId.equals("minecraft:enderman") || mobId.equals("minecraft:piglin") || mobId.equals("minecraft:zombified_piglin") || mobId.equals("minecraft:iron_golem") || mobId.equals("minecraft:spider") || mobId.equals("minecraft:cave_spider") || mobId.equals("minecraft:wolf") || mobId.equals("minecraft:polar_bear") || mobId.equals("minecraft:bee") || mobId.equals("minecraft:panda") || mobId.equals("minecraft:llama") || mobId.equals("minecraft:dolphin") || mobId.equals("minecraft:trader_llama") || mobId.equals("minecraft:slime") || mobId.equals("minecraft:magma_cube") || MobBuffUtil.hasAttackGoal(mob);
    }

    private static boolean hasAttackGoal(class_1308 mob) {
        try {
            Field goals = class_1355.class.getDeclaredField("goals");
            goals.setAccessible(true);
            Field mobGoalSelector = class_1308.class.getDeclaredField("goalSelector");
            mobGoalSelector.setAccessible(true);
            Object goalSelector = mobGoalSelector.get(mob);
            Set goalSet = (Set)goals.get(goalSelector);
            for (Object prioritizedGoal : goalSet) {
                Object goal = prioritizedGoal.getClass().getMethod("getGoal", new Class[0]).invoke(prioritizedGoal, new Object[0]);
                String goalName = goal.getClass().getSimpleName();
                if (!goalName.contains("Attack") && !goalName.contains("Melee") && !goalName.contains("Ranged") && !goalName.contains("Combat")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void applyAttributeModifiers(class_1308 mob, double dayMultiplier, DimensionMultipliers dimMultipliers) {
        class_1324 toughnessAttr;
        double toughnessAdd;
        class_1324 armorAttr;
        double armorAdd;
        class_1324 attackSpeedAttr;
        double attackSpeedMult;
        class_1324 speedAttr;
        double speedMult;
        class_1324 damageAttr;
        double damageMult;
        class_1324 healthAttr;
        double healthMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.healthMultiplier, dimMultipliers.health, dayMultiplier);
        if (healthMult > 1.0 && (healthAttr = mob.method_5996(class_5134.field_23716)) != null) {
            healthAttr.method_6200(HEALTH_MODIFIER_ID);
            healthAttr.method_26835(new class_1322(HEALTH_MODIFIER_ID, healthMult - 1.0, class_1322.class_1323.field_6330));
        }
        if ((damageMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.damageMultiplier, dimMultipliers.damage, dayMultiplier)) > 1.0 && (damageAttr = mob.method_5996(class_5134.field_23721)) != null) {
            class_2960 damageId = class_2960.method_60655((String)"buffmobs", (String)"temp_damage");
            damageAttr.method_6200(damageId);
            damageAttr.method_26835(new class_1322(damageId, damageMult - 1.0, class_1322.class_1323.field_6330));
        }
        if ((speedMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.speedMultiplier, dimMultipliers.speed, dayMultiplier)) > 1.0 && speedMult < 3.0 && (speedAttr = mob.method_5996(class_5134.field_23719)) != null) {
            class_2960 speedId = class_2960.method_60655((String)"buffmobs", (String)"temp_speed");
            speedAttr.method_6200(speedId);
            double cappedMult = Math.min(speedMult, 1.5);
            double speedBonus = (cappedMult - 1.0) * 0.2;
            speedAttr.method_26835(new class_1322(speedId, speedBonus, class_1322.class_1323.field_6330));
        }
        if ((attackSpeedMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.attackSpeedMultiplier, dimMultipliers.attackSpeed, dayMultiplier)) > 1.0 && (attackSpeedAttr = mob.method_5996(class_5134.field_23723)) != null) {
            class_2960 attackSpeedId = class_2960.method_60655((String)"buffmobs", (String)"temp_attack_speed");
            attackSpeedAttr.method_6200(attackSpeedId);
            double cappedAttackMult = Math.min(attackSpeedMult, 2.5);
            attackSpeedAttr.method_26835(new class_1322(attackSpeedId, cappedAttackMult - 1.0, class_1322.class_1323.field_6330));
        }
        if ((armorAdd = MobBuffUtil.calculateFinalAddition(BuffMobsMod.CONFIG.attributes.armorAddition, dimMultipliers.armor, dayMultiplier)) > 0.0 && (armorAttr = mob.method_5996(class_5134.field_23724)) != null) {
            class_2960 armorId = class_2960.method_60655((String)"buffmobs", (String)"temp_armor");
            armorAttr.method_6200(armorId);
            armorAttr.method_26835(new class_1322(armorId, armorAdd, class_1322.class_1323.field_6328));
        }
        if ((toughnessAdd = MobBuffUtil.calculateFinalAddition(BuffMobsMod.CONFIG.attributes.armorToughnessAddition, dimMultipliers.armorToughness, dayMultiplier)) > 0.0 && (toughnessAttr = mob.method_5996(class_5134.field_23725)) != null) {
            class_2960 toughnessId = class_2960.method_60655((String)"buffmobs", (String)"temp_toughness");
            toughnessAttr.method_6200(toughnessId);
            toughnessAttr.method_26835(new class_1322(toughnessId, toughnessAdd, class_1322.class_1323.field_6328));
        }
    }

    private static void applyVanillaStatusEffects(class_1308 mob) {
        int duration = BuffMobsMod.CONFIG.effects.duration == -1 ? -1 : BuffMobsMod.CONFIG.effects.duration * 20;
        boolean showParticles = BuffMobsMod.CONFIG.visualEffects;
        MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5910, BuffMobsMod.CONFIG.effects.strengthAmplifier, duration, showParticles);
        MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5907, BuffMobsMod.CONFIG.effects.resistanceAmplifier, duration, showParticles);
        if (BuffMobsMod.CONFIG.effects.regenerationAmplifier > 0 && !mob.method_5864().method_20210(class_3483.field_46232)) {
            MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5924, BuffMobsMod.CONFIG.effects.regenerationAmplifier, duration, showParticles);
        }
    }

    private static void refreshEffect(class_1308 mob, class_6880<class_1291> effect, int amplifier, int duration, boolean showParticles) {
        if (amplifier <= 0) {
            return;
        }
        class_1293 current = mob.method_6112(effect);
        if (current == null || current.method_5584() < 1200) {
            mob.method_6016(effect);
            mob.method_6092(new class_1293(effect, duration, amplifier - 1, false, showParticles, true));
        }
    }

    private static void addEffect(class_1308 mob, class_6880<class_1291> effect, int amplifier, int duration, boolean showParticles) {
        if (amplifier > 0) {
            mob.method_6092(new class_1293(effect, duration, amplifier - 1, false, showParticles, true));
        }
    }

    private static boolean isValidDimension(String dimensionName) {
        List<String> blacklist = BuffMobsMod.CONFIG.dimensionFilter.blacklist;
        if (blacklist.contains(dimensionName)) {
            return false;
        }
        if (BuffMobsMod.CONFIG.dimensionFilter.useWhitelist) {
            return BuffMobsMod.CONFIG.dimensionFilter.whitelist.contains(dimensionName);
        }
        return true;
    }

    private static boolean isValidModId(String modId) {
        List<String> blacklist = BuffMobsMod.CONFIG.modidFilter.blacklist;
        if (blacklist.contains(modId)) {
            return false;
        }
        if (BuffMobsMod.CONFIG.modidFilter.useWhitelist) {
            return BuffMobsMod.CONFIG.modidFilter.whitelist.contains(modId);
        }
        return true;
    }

    private static boolean isValidMobId(String mobId) {
        List<String> blacklist = BuffMobsMod.CONFIG.mobFilter.blacklist;
        if (blacklist.contains(mobId)) {
            return false;
        }
        if (BuffMobsMod.CONFIG.mobFilter.useWhitelist) {
            return BuffMobsMod.CONFIG.mobFilter.whitelist.contains(mobId);
        }
        return true;
    }

    public static double calculateFinalMultiplier(double baseMultiplier, double dimensionMultiplier, double dayMultiplier) {
        if (baseMultiplier > 1.0) {
            return baseMultiplier * dimensionMultiplier * dayMultiplier;
        }
        if (dimensionMultiplier > 1.0) {
            return dimensionMultiplier * dayMultiplier;
        }
        return 1.0;
    }

    public static double calculateFinalAddition(double baseAddition, double dimensionAddition, double dayMultiplier) {
        if (baseAddition > 0.0) {
            return (baseAddition + dimensionAddition) * dayMultiplier;
        }
        if (dimensionAddition > 0.0) {
            return dimensionAddition * dayMultiplier;
        }
        return 0.0;
    }

    public static class DimensionMultipliers {
        public final double health;
        public final double damage;
        public final double speed;
        public final double attackSpeed;
        public final double armor;
        public final double armorToughness;

        public DimensionMultipliers(double health, double damage, double speed, double attackSpeed, double armor, double armorToughness) {
            this.health = health;
            this.damage = damage;
            this.speed = speed;
            this.attackSpeed = attackSpeed;
            this.armor = armor;
            this.armorToughness = armorToughness;
        }
    }
}

