/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.event;

import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.util.MobBuffUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;

public class MobEventHandler {
    private final Map<String, Long> lastDayCheck = new HashMap<String, Long>();
    private final RandomSource random = RandomSource.create();

    public void onLivingDamage(LivingEntity entity, DamageSource source, float damageTaken) {
        if (!((Boolean)BuffMobsConfig.enabled.get()).booleanValue() || !((Boolean)BuffMobsConfig.HarmfulEffects.enabled.get()).booleanValue()) {
            return;
        }
        if (entity instanceof Player) {
            Mob mob;
            Projectile projectile;
            Entity entity2;
            Mob mob2;
            Player player = (Player)entity;
            Entity attacker = source.getEntity();
            Entity directEntity = source.getDirectEntity();
            Mob attackingMob = null;
            if (attacker instanceof Mob && MobBuffUtil.isValidMob(mob2 = (Mob)attacker)) {
                attackingMob = mob2;
            } else if (directEntity instanceof Projectile && (entity2 = (projectile = (Projectile)directEntity).getOwner()) instanceof Mob && MobBuffUtil.isValidMob(mob = (Mob)entity2)) {
                attackingMob = mob;
            }
            if (attackingMob != null && (double)this.random.nextFloat() < (Double)BuffMobsConfig.HarmfulEffects.chance.get()) {
                this.applyRandomHarmfulEffect(player);
            }
        }
    }

    public void onWorldTick(ServerLevel world) {
        if (!((Boolean)BuffMobsConfig.enabled.get()).booleanValue()) {
            return;
        }
        this.handleDayScaling(world);
    }

    private void handleDayScaling(ServerLevel world) {
        if (!((Boolean)BuffMobsConfig.DayScaling.enabled.get()).booleanValue() || !((Boolean)BuffMobsConfig.DayScaling.showNotifications.get()).booleanValue() || world.players().isEmpty()) {
            return;
        }
        long currentTime = world.getDayTime();
        long currentDay = currentTime / 24000L;
        String worldKey = world.dimension().location().toString();
        Long lastCheckedDay = this.lastDayCheck.get(worldKey);
        if (lastCheckedDay == null || currentDay > lastCheckedDay) {
            this.lastDayCheck.put(worldKey, currentDay);
            if (lastCheckedDay != null && currentDay > 0L) {
                boolean shouldNotify = false;
                int scalingInterval = (Integer)BuffMobsConfig.DayScaling.interval.get();
                switch ((BuffMobsConfig.DayScaling.NotificationMode)((Object)BuffMobsConfig.DayScaling.notificationMode.get())) {
                    case EVERY_DAY: {
                        shouldNotify = true;
                        break;
                    }
                    case SCALING_INCREASE_ONLY: {
                        boolean bl = shouldNotify = currentDay % (long)scalingInterval == 0L;
                    }
                }
                if (shouldNotify) {
                    this.sendDayScalingNotification(world, currentDay);
                }
            }
        }
    }

    private void sendDayScalingNotification(ServerLevel world, long currentDay) {
        boolean isMaxed;
        double currentMultiplier = MobBuffUtil.getDayMultiplier(world.getDayTime());
        double maxMultiplier = (Double)BuffMobsConfig.DayScaling.maxMultiplier.get();
        int scalingInterval = (Integer)BuffMobsConfig.DayScaling.interval.get();
        long daysUntilNextScaling = (long)scalingInterval - currentDay % (long)scalingInterval;
        if (daysUntilNextScaling == (long)scalingInterval) {
            daysUntilNextScaling = 0L;
        }
        boolean bl = isMaxed = currentMultiplier >= maxMultiplier;
        MutableComponent message = isMaxed ? Component.literal((String)String.format("Day %d - Mob Scaling: %.1fx (MAXIMUM)", currentDay, currentMultiplier)) : Component.literal((String)String.format("Day %d - Mob Scaling: %.1fx | Next increase in %d day%s", currentDay, currentMultiplier, daysUntilNextScaling, daysUntilNextScaling != 1L ? "s" : ""));
        world.players().forEach(arg_0 -> MobEventHandler.lambda$sendDayScalingNotification$0((Component)message, arg_0));
    }

    private void applyRandomHarmfulEffect(Player player) {
        int effectType = this.random.nextInt(3);
        switch (effectType) {
            case 0: {
                MobBuffUtil.applyPoisonToPlayer(player, (Integer)BuffMobsConfig.HarmfulEffects.poisonDuration.get());
                break;
            }
            case 1: {
                MobBuffUtil.applySlownessToPlayer(player, (Integer)BuffMobsConfig.HarmfulEffects.slownessDuration.get());
                break;
            }
            case 2: {
                MobBuffUtil.applyWitherToPlayer(player, (Integer)BuffMobsConfig.HarmfulEffects.witherDuration.get());
            }
        }
    }

    private static /* synthetic */ void lambda$sendDayScalingNotification$0(Component message, ServerPlayer player) {
        player.sendSystemMessage(message);
    }
}

