/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.util.MobBuffUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MeleeWeaponManager {
    private static final RandomSource RANDOM = RandomSource.create();

    public static ItemStack generateMeleeWeapon(Mob mob) {
        Level world = mob.level();
        String dimensionName = world.dimension().location().toString();
        double dayMultiplier = MobBuffUtil.getDayMultiplier(world.getDayTime());
        ItemStack weapon = MeleeWeaponManager.createWeaponForDimension(dimensionName, dayMultiplier);
        if (((Boolean)BuffMobsConfig.RangedMeleeSwitching.enchantmentsEnabled.get()).booleanValue()) {
            MeleeWeaponManager.applyEnchantments(weapon, dayMultiplier, world);
        }
        return weapon;
    }

    private static ItemStack createWeaponForDimension(String dimension, double dayMultiplier) {
        List<WeaponTier> availableTiers = MeleeWeaponManager.getAvailableTiers(dimension, dayMultiplier);
        if (availableTiers.isEmpty()) {
            return new ItemStack((ItemLike)Items.STONE_SWORD);
        }
        double totalWeight = availableTiers.stream().mapToDouble(t -> t.weight).sum();
        double roll = RANDOM.nextDouble() * totalWeight;
        double current = 0.0;
        for (WeaponTier tier : availableTiers) {
            if (!(roll <= (current += tier.weight))) continue;
            return new ItemStack((ItemLike)tier.item);
        }
        return new ItemStack((ItemLike)availableTiers.get((int)0).item);
    }

    private static List<WeaponTier> getAvailableTiers(String dimension, double dayMultiplier) {
        ArrayList<WeaponTier> tiers = new ArrayList<WeaponTier>();
        long worldDays = MeleeWeaponManager.calculateWorldDays(dayMultiplier);
        if (dimension.equals("minecraft:the_nether")) {
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.goldenAxeUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.GOLDEN_AXE, 50.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.diamondAxeUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.DIAMOND_AXE, 10.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.netheriteAxeUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.NETHERITE_AXE, 1.0));
            }
        } else if (dimension.equals("minecraft:overworld")) {
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.stoneSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.STONE_SWORD, 50.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.ironSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.IRON_SWORD, 30.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.diamondSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.DIAMOND_SWORD, 5.0));
            }
        } else if (dimension.equals("minecraft:the_end")) {
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.stoneSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.STONE_SWORD, 40.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.ironSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.IRON_SWORD, 30.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.diamondSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.DIAMOND_SWORD, 15.0));
            }
            if (worldDays >= (long)((Integer)BuffMobsConfig.RangedMeleeSwitching.netheriteSwordUnlockDay.get()).intValue()) {
                tiers.add(new WeaponTier(Items.NETHERITE_SWORD, 1.0));
            }
        } else {
            tiers.add(new WeaponTier(Items.STONE_SWORD, 60.0));
            tiers.add(new WeaponTier(Items.IRON_SWORD, 40.0));
        }
        return tiers;
    }

    private static void applyEnchantments(ItemStack weapon, double dayMultiplier, Level world) {
        int maxEnchantments = MeleeWeaponManager.calculateMaxEnchantments(dayMultiplier);
        long worldDays = MeleeWeaponManager.calculateWorldDays(dayMultiplier);
        ArrayList<EnchantmentTier> availableEnchantments = new ArrayList<EnchantmentTier>();
        Registry enchantmentRegistry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (Registry<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.SHARPNESS, worldDays, (Integer)BuffMobsConfig.RangedMeleeSwitching.sharpnessUnlockDay.get(), (Integer)BuffMobsConfig.RangedMeleeSwitching.sharpnessMaxLevel.get(), 40.0, dayMultiplier);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (Registry<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, worldDays, (Integer)BuffMobsConfig.RangedMeleeSwitching.fireAspectUnlockDay.get(), (Integer)BuffMobsConfig.RangedMeleeSwitching.fireAspectMaxLevel.get(), 25.0, dayMultiplier);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (Registry<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK, worldDays, (Integer)BuffMobsConfig.RangedMeleeSwitching.knockbackUnlockDay.get(), (Integer)BuffMobsConfig.RangedMeleeSwitching.knockbackMaxLevel.get(), 20.0, dayMultiplier);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (Registry<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, worldDays, (Integer)BuffMobsConfig.RangedMeleeSwitching.sweepingEdgeUnlockDay.get(), (Integer)BuffMobsConfig.RangedMeleeSwitching.sweepingEdgeMaxLevel.get(), 15.0, dayMultiplier);
        MeleeWeaponManager.applyRandomEnchantments(weapon, availableEnchantments, maxEnchantments, world);
    }

    private static void addEnchantmentIfUnlocked(List<EnchantmentTier> list, Registry<Enchantment> registry, ResourceKey<Enchantment> key, long worldDays, int unlockDay, int maxLevel, double weight, double dayMultiplier) {
        if (worldDays >= (long)unlockDay) {
            int level = MeleeWeaponManager.calculateEnchantmentLevel(maxLevel, unlockDay, dayMultiplier);
            Holder.Reference enchantment = registry.getHolder(key).orElse(null);
            if (enchantment != null) {
                list.add(new EnchantmentTier((Holder<Enchantment>)enchantment, level, weight));
            }
        }
    }

    private static void applyRandomEnchantments(ItemStack weapon, List<EnchantmentTier> available, int maxCount, Level world) {
        int toApply = Math.min(maxCount, available.size());
        ArrayList<EnchantmentTier> remaining = new ArrayList<EnchantmentTier>(available);
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (int i = 0; i < toApply && !remaining.isEmpty(); ++i) {
            double totalWeight = remaining.stream().mapToDouble(e -> e.weight).sum();
            double roll = RANDOM.nextDouble() * totalWeight;
            double current = 0.0;
            EnchantmentTier selected = null;
            for (EnchantmentTier ench : remaining) {
                if (!(roll <= (current += ench.weight))) continue;
                selected = ench;
                break;
            }
            if (selected == null) continue;
            enchantments.set(selected.enchantment, selected.level);
            remaining.remove(selected);
        }
        EnchantmentHelper.setEnchantments((ItemStack)weapon, (ItemEnchantments)enchantments.toImmutable());
    }

    private static int calculateMaxEnchantments(double dayMultiplier) {
        int baseMax = (Integer)BuffMobsConfig.RangedMeleeSwitching.maxEnchantmentsPerWeapon.get();
        if (dayMultiplier >= 3.0) {
            return Math.min(4, baseMax);
        }
        if (dayMultiplier >= 2.0) {
            return Math.min(3, baseMax);
        }
        if (dayMultiplier >= 1.5) {
            return Math.min(2, baseMax);
        }
        return Math.min(1, baseMax);
    }

    private static int calculateEnchantmentLevel(int maxLevel, int unlockDay, double dayMultiplier) {
        if (maxLevel <= 1) {
            return 1;
        }
        long worldDays = MeleeWeaponManager.calculateWorldDays(dayMultiplier);
        long daysAfterUnlock = Math.max(0L, worldDays - (long)unlockDay);
        int daysPerLevel = (Integer)BuffMobsConfig.RangedMeleeSwitching.daysPerEnchantmentLevel.get();
        int level = 1 + (int)(daysAfterUnlock / (long)daysPerLevel);
        return Math.min(level, maxLevel);
    }

    private static long calculateWorldDays(double dayMultiplier) {
        if (dayMultiplier <= 1.0) {
            return 0L;
        }
        return (long)((dayMultiplier - 1.0) / (Double)BuffMobsConfig.DayScaling.multiplier.get()) * (long)((Integer)BuffMobsConfig.DayScaling.interval.get()).intValue();
    }

    private static class WeaponTier {
        final Item item;
        final double weight;

        WeaponTier(Item item, double weight) {
            this.item = item;
            this.weight = weight;
        }
    }

    private static class EnchantmentTier {
        final Holder<Enchantment> enchantment;
        final int level;
        final double weight;

        EnchantmentTier(Holder<Enchantment> enchantment, int level, double weight) {
            this.enchantment = enchantment;
            this.level = level;
            this.weight = weight;
        }
    }
}

