/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class MobPresetUtil {
    public static PresetMultipliers getPresetForMob(Mob mob) {
        if (BuffMobsConfig.MobPresets.enabled.get() != BuffMobsConfig.MobPresets.PresetToggle.ENABLED) {
            return null;
        }
        ResourceLocation mobType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        String mobId = mobType.toString();
        BuffMobsMod.LOGGER.info("[PRESET] Checking mob: {}", (Object)mobId);
        for (String mapping : (List)BuffMobsConfig.MobPresets.mobMapping.get()) {
            String[] parts = mapping.split(":");
            if (parts.length < 3) {
                BuffMobsMod.LOGGER.warn("[PRESET] Invalid mapping format: {}", (Object)mapping);
                continue;
            }
            String mappedNamespace = parts[0];
            String mappedPath = parts[1];
            String presetName = parts[2];
            String mappedMobId = mappedNamespace + ":" + mappedPath;
            BuffMobsMod.LOGGER.info("[PRESET] Checking mapping '{}' -> preset '{}'", (Object)mappedMobId, (Object)presetName);
            if (!mappedMobId.equals(mobId)) continue;
            BuffMobsMod.LOGGER.info("[PRESET] *** MATCH FOUND! ***");
            PresetMultipliers result = MobPresetUtil.getPresetByName(presetName);
            if (result != null) {
                BuffMobsMod.LOGGER.info("[PRESET] Applied preset '{}' to '{}': HP={}x, DMG={}x", new Object[]{presetName, mobId, result.health, result.damage});
                return result;
            }
            BuffMobsMod.LOGGER.warn("[PRESET] Preset '{}' not found!", (Object)presetName);
        }
        BuffMobsMod.LOGGER.info("[PRESET] No preset found for {}", (Object)mobId);
        return null;
    }

    public static PresetMultipliers getPresetByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        BuffMobsConfig.MobPresets.PresetSlot slot = null;
        if (((String)BuffMobsConfig.MobPresets.preset1.presetName.get()).equals(name)) {
            slot = BuffMobsConfig.MobPresets.preset1;
        } else if (((String)BuffMobsConfig.MobPresets.preset2.presetName.get()).equals(name)) {
            slot = BuffMobsConfig.MobPresets.preset2;
        } else if (((String)BuffMobsConfig.MobPresets.preset3.presetName.get()).equals(name)) {
            slot = BuffMobsConfig.MobPresets.preset3;
        } else if (((String)BuffMobsConfig.MobPresets.preset4.presetName.get()).equals(name)) {
            slot = BuffMobsConfig.MobPresets.preset4;
        } else if (((String)BuffMobsConfig.MobPresets.preset5.presetName.get()).equals(name)) {
            slot = BuffMobsConfig.MobPresets.preset5;
        }
        if (slot == null) {
            return null;
        }
        return new PresetMultipliers((Double)slot.healthMultiplier.get(), (Double)slot.damageMultiplier.get(), (Double)slot.speedMultiplier.get(), (Double)slot.attackSpeedMultiplier.get(), (Double)slot.armorAddition.get(), (Double)slot.armorToughnessAddition.get());
    }

    public static class PresetMultipliers {
        public final double health;
        public final double damage;
        public final double speed;
        public final double attackSpeed;
        public final double armor;
        public final double armorToughness;

        public PresetMultipliers(double health, double damage, double speed, double attackSpeed, double armor, double armorToughness) {
            this.health = health;
            this.damage = damage;
            this.speed = speed;
            this.attackSpeed = attackSpeed;
            this.armor = armor;
            this.armorToughness = armorToughness;
        }
    }
}

