/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.command;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.event.MobTickHandler;
import com.khotyz.buffmobs.util.MobBuffUtil;
import com.khotyz.buffmobs.util.MobPresetUtil;
import com.khotyz.buffmobs.util.RangedMobAIManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;

public class DebugCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"buffmobs").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"debug").executes(DebugCommand::debugNearestMob))).then(Commands.literal((String)"reload").executes(DebugCommand::reloadMobs))).then(Commands.literal((String)"info").executes(DebugCommand::showInfo))).then(Commands.literal((String)"presets").executes(DebugCommand::showPresets)));
    }

    private static int debugNearestMob(CommandContext<CommandSourceStack> context) {
        AttributeInstance damage;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.getPlayer() == null) {
            source.sendFailure((Component)Component.literal((String)"Must be executed by a player!"));
            return 0;
        }
        AABB searchBox = source.getPlayer().getBoundingBox().inflate(5.0);
        List nearbyMobs = source.getLevel().getEntitiesOfClass(Mob.class, searchBox, mob -> true);
        if (nearbyMobs.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No mobs nearby! Get closer."));
            return 0;
        }
        Mob closestMob = (Mob)nearbyMobs.get(0);
        double closestDist = source.getPlayer().distanceToSqr((Entity)closestMob);
        for (Mob mob2 : nearbyMobs) {
            double dist = source.getPlayer().distanceToSqr((Entity)mob2);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestMob = mob2;
        }
        Mob mob3 = closestMob;
        String mobId = mob3.getType().toString();
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== BuffMobs Debug ==="), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eMob: \u00a7f" + mob3.getType().toString())), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eMob ID: \u00a7f" + mobId)), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eDimension: \u00a7f" + String.valueOf(mob3.level().dimension().location()))), false);
        boolean isValid = MobBuffUtil.isValidMob(mob3);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eValid for buffs: \u00a7f" + (isValid ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (!isValid) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cMob is filtered out!"), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Ranged/Melee System ==="), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eSystem Enabled: \u00a7f" + ((Boolean)BuffMobsConfig.RangedMeleeSwitching.enabled.get() != false ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (RangedMobAIManager.isRangedMob(mob3)) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7eIs Ranged Mob: \u00a7aYES"), false);
            source.sendSuccess(() -> Component.literal((String)("\u00a7eBehavior Mode (Config): \u00a7f" + String.valueOf(BuffMobsConfig.RangedMeleeSwitching.behaviorMode.get()))), false);
            source.sendSuccess(() -> Component.literal((String)("\u00a7eIn Melee Mode: \u00a7f" + (RangedMobAIManager.isInMeleeMode(mob3) ? "\u00a7aYES" : "\u00a7cNO"))), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"\u00a7eIs Ranged Mob: \u00a7cNO"), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Preset System ==="), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7ePresets Enabled: \u00a7f" + ((Boolean)BuffMobsConfig.MobPresets.enabled.get() != false ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (((Boolean)BuffMobsConfig.MobPresets.enabled.get()).booleanValue()) {
            MobPresetUtil.PresetMultipliers preset = MobPresetUtil.getPresetForMob(mob3);
            if (preset != null) {
                source.sendSuccess(() -> Component.literal((String)"\u00a7ePreset Found: \u00a7aYES"), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a7ePreset Health: \u00a7f" + preset.health + "x")), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a7ePreset Damage: \u00a7f" + preset.damage + "x")), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a7ePreset Speed: \u00a7f" + preset.speed + "x")), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a7ePreset Attack Speed: \u00a7f" + preset.attackSpeed + "x")), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a7ePreset Armor: \u00a7f+" + preset.armor)), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a7ePreset Toughness: \u00a7f+" + preset.armorToughness)), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)"\u00a7ePreset Found: \u00a7cNO"), false);
                source.sendSuccess(() -> Component.literal((String)"\u00a77Using dimension/default scaling"), false);
                source.sendSuccess(() -> Component.literal((String)""), false);
                source.sendSuccess(() -> Component.literal((String)"\u00a77Available mappings:"), false);
                for (String mapping : (List)BuffMobsConfig.MobPresets.mobMapping.get()) {
                    source.sendSuccess(() -> Component.literal((String)("\u00a77  - " + mapping)), false);
                }
                source.sendSuccess(() -> Component.literal((String)""), false);
                source.sendSuccess(() -> Component.literal((String)"\u00a77To add this mob, use format:"), false);
                source.sendSuccess(() -> Component.literal((String)("\u00a77  " + mobId + ":preset_name")), false);
            }
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Scaling ==="), false);
        double dayMult = MobBuffUtil.getDayMultiplier(mob3.level().getDayTime());
        source.sendSuccess(() -> Component.literal((String)("\u00a7eDay Multiplier: \u00a7f" + String.format("%.2f", dayMult))), false);
        MobBuffUtil.DimensionMultipliers dimMult = MobBuffUtil.getDimensionMultipliers(mob3);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eDim Health Mult: \u00a7f" + dimMult.health)), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eDim Damage Mult: \u00a7f" + dimMult.damage)), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Current Stats ==="), false);
        AttributeInstance health = mob3.getAttribute(Attributes.MAX_HEALTH);
        if (health != null) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7eHealth: \u00a7f" + String.format("%.1f / %.1f", Float.valueOf(mob3.getHealth()), health.getValue()))), false);
            source.sendSuccess(() -> Component.literal((String)("\u00a7eBase Health: \u00a7f" + String.format("%.1f", health.getBaseValue()))), false);
        }
        if ((damage = mob3.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7eAttack Damage: \u00a7f" + String.format("%.1f (base: %.1f)", damage.getValue(), damage.getBaseValue()))), false);
        }
        source.sendSuccess(() -> Component.literal((String)("\u00a7eActive Effects: \u00a7f" + mob3.getActiveEffects().size())), false);
        mob3.getActiveEffects().forEach(effect -> source.sendSuccess(() -> Component.literal((String)("  \u00a77- " + ((MobEffect)effect.getEffect().value()).getDisplayName().getString() + " " + (effect.getAmplifier() + 1))), false));
        return 1;
    }

    private static int showPresets(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== BuffMobs Presets ==="), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eEnabled: \u00a7f" + ((Boolean)BuffMobsConfig.MobPresets.enabled.get() != false ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (!((Boolean)BuffMobsConfig.MobPresets.enabled.get()).booleanValue()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cPresets are disabled in config!"), false);
            return 1;
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Available Presets ==="), false);
        BuffMobsConfig.MobPresets.PresetSlot[] presets = new BuffMobsConfig.MobPresets.PresetSlot[]{BuffMobsConfig.MobPresets.preset1, BuffMobsConfig.MobPresets.preset2, BuffMobsConfig.MobPresets.preset3, BuffMobsConfig.MobPresets.preset4, BuffMobsConfig.MobPresets.preset5};
        int presetNum = 1;
        for (BuffMobsConfig.MobPresets.PresetSlot preset : presets) {
            if (!((String)preset.presetName.get()).isEmpty()) {
                int num = presetNum;
                source.sendSuccess(() -> Component.literal((String)String.format("\u00a7e%d. \u00a7f%s \u00a77(HP: %.1fx, DMG: %.1fx, SPD: %.1fx, ASPD: %.1fx, ARM: +%.0f, TOUGH: +%.0f)", num, preset.presetName.get(), preset.healthMultiplier.get(), preset.damageMultiplier.get(), preset.speedMultiplier.get(), preset.attackSpeedMultiplier.get(), preset.armorAddition.get(), preset.armorToughnessAddition.get())), false);
            }
            ++presetNum;
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Mob Mappings ==="), false);
        if (((List)BuffMobsConfig.MobPresets.mobMapping.get()).isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cNo mappings configured!"), false);
        } else {
            for (String mapping : (List)BuffMobsConfig.MobPresets.mobMapping.get()) {
                String[] parts = mapping.split(":");
                if (parts.length >= 3) {
                    String mobId = parts[0] + ":" + parts[1];
                    String presetName = parts[2];
                    source.sendSuccess(() -> Component.literal((String)("\u00a77- \u00a7f" + mobId + " \u00a77\u2192 \u00a7e" + presetName)), false);
                    continue;
                }
                source.sendSuccess(() -> Component.literal((String)("\u00a7c- Invalid: " + mapping)), false);
            }
        }
        return 1;
    }

    private static int reloadMobs(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a76Reapplying buffs to all mobs..."), false);
        int count = 0;
        for (Entity entity : source.getLevel().getAllEntities()) {
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            try {
                MobBuffUtil.applyBuffs(mob);
                ++count;
            }
            catch (Exception e) {
                BuffMobsMod.LOGGER.error("Failed to buff mob", (Throwable)e);
            }
        }
        int finalCount = count;
        source.sendSuccess(() -> Component.literal((String)("\u00a7aBuffed " + finalCount + " mobs!")), false);
        return 1;
    }

    private static int showInfo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== BuffMobs Info ==="), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eEnabled: \u00a7f" + String.valueOf(BuffMobsConfig.enabled.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eInitialized Mobs: \u00a7f" + MobTickHandler.getInitializedCount())), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eHealth Mult: \u00a7f" + String.valueOf(BuffMobsConfig.Attributes.healthMultiplier.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eDamage Mult: \u00a7f" + String.valueOf(BuffMobsConfig.Attributes.damageMultiplier.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eDay Scaling: \u00a7f" + String.valueOf(BuffMobsConfig.DayScaling.enabled.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7ePresets: \u00a7f" + String.valueOf(BuffMobsConfig.MobPresets.enabled.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eRanged/Melee: \u00a7f" + String.valueOf(BuffMobsConfig.RangedMeleeSwitching.enabled.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eBehavior Mode: \u00a7f" + String.valueOf(BuffMobsConfig.RangedMeleeSwitching.behaviorMode.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eUse whitelist (mobs): \u00a7f" + String.valueOf(BuffMobsConfig.MobFilter.useWhitelist.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eUse whitelist (mods): \u00a7f" + String.valueOf(BuffMobsConfig.ModIdFilter.useWhitelist.get()))), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7eUse whitelist (dims): \u00a7f" + String.valueOf(BuffMobsConfig.DimensionFilter.useWhitelist.get()))), false);
        return 1;
    }
}

