/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.event;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.util.MobBuffUtil;
import com.khotyz.buffmobs.util.RangedMobAIManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="buffmobs")
public class MobTickHandler {
    private static final Set<UUID> INITIALIZED_MOBS = new HashSet<UUID>();
    private static int globalTickCounter = 0;
    private static boolean initialScanDone = false;

    public static void register() {
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        BuffMobsMod.LOGGER.info("Server started - scanning for existing mobs...");
        int count = 0;
        for (ServerLevel world : event.getServer().getAllLevels()) {
            for (Entity entity : world.getAllEntities()) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                MobTickHandler.initializeMob(mob);
                ++count;
            }
        }
        BuffMobsMod.LOGGER.info("Initialized {} existing mobs", (Object)count);
        initialScanDone = true;
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!event.getLevel().isClientSide() && !INITIALIZED_MOBS.contains(mob.getUUID())) {
                MobTickHandler.initializeMob(mob);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (!((Boolean)BuffMobsConfig.enabled.get()).booleanValue()) {
            return;
        }
        ++globalTickCounter;
        for (ServerLevel level : event.getServer().getAllLevels()) {
            if (globalTickCounter % 100 == 0 && !initialScanDone) {
                for (Entity entity2 : level.getAllEntities()) {
                    Mob mob;
                    if (!(entity2 instanceof Mob) || INITIALIZED_MOBS.contains((mob = (Mob)entity2).getUUID())) continue;
                    MobTickHandler.initializeMob(mob);
                }
            }
            if (globalTickCounter % 20 != 0) continue;
            level.getAllEntities().forEach(entity -> {
                Mob mob;
                if (entity instanceof Mob && !(mob = (Mob)entity).isRemoved()) {
                    UUID uuid = mob.getUUID();
                    if (!INITIALIZED_MOBS.contains(uuid)) {
                        MobTickHandler.initializeMob(mob);
                    } else {
                        try {
                            RangedMobAIManager.updateMobBehavior(mob);
                            MobBuffUtil.refreshInfiniteEffects(mob);
                        }
                        catch (Exception e) {
                            BuffMobsMod.LOGGER.warn("Error updating mob behavior", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            INITIALIZED_MOBS.remove(mob.getUUID());
            RangedMobAIManager.cleanup(mob);
        }
    }

    private static void initializeMob(Mob mob) {
        if (!((Boolean)BuffMobsConfig.enabled.get()).booleanValue()) {
            return;
        }
        UUID uuid = mob.getUUID();
        if (INITIALIZED_MOBS.contains(uuid)) {
            return;
        }
        try {
            if (MobBuffUtil.isValidMob(mob)) {
                MobBuffUtil.applyBuffs(mob);
                RangedMobAIManager.initializeMob(mob);
                INITIALIZED_MOBS.add(uuid);
                if (BuffMobsMod.LOGGER.isDebugEnabled()) {
                    BuffMobsMod.LOGGER.debug("Initialized mob: {} ({}) in {}", new Object[]{mob.getType().toString(), mob.getUUID(), mob.level().dimension().location()});
                }
            }
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.error("Failed to initialize mob: {}", (Object)mob.getType(), (Object)e);
        }
    }

    public static int getInitializedCount() {
        return INITIALIZED_MOBS.size();
    }
}

