/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.util.MobPresetUtil;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;

public class MobBuffUtil {
    private static final ResourceLocation HEALTH_MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"buffmobs", (String)"health");
    private static final ResourceLocation DAMAGE_MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"buffmobs", (String)"damage");
    private static final ResourceLocation SPEED_MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"buffmobs", (String)"speed");
    private static final ResourceLocation ATTACK_SPEED_MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"buffmobs", (String)"attack_speed");
    private static final ResourceLocation ARMOR_MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"buffmobs", (String)"armor");
    private static final ResourceLocation TOUGHNESS_MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"buffmobs", (String)"toughness");

    public static void applyBuffs(Mob mob) {
        if (!((Boolean)BuffMobsConfig.enabled.get()).booleanValue() || !MobBuffUtil.isValidMob(mob)) {
            return;
        }
        double dayMultiplier = MobBuffUtil.getDayMultiplier(mob.level().getDayTime());
        MobPresetUtil.PresetMultipliers presetMult = MobPresetUtil.getPresetForMob(mob);
        if (presetMult != null) {
            BuffMobsMod.LOGGER.debug("Applying preset buffs to {} - Day mult: {}, Preset: health={}, damage={}", new Object[]{mob.getType(), dayMultiplier, presetMult.health, presetMult.damage});
            MobBuffUtil.applyAttributeModifiersWithPreset(mob, dayMultiplier, presetMult);
        } else {
            DimensionMultipliers dimMultipliers = MobBuffUtil.getDimensionMultipliers(mob);
            BuffMobsMod.LOGGER.debug("Applying standard buffs to {} - Day mult: {}, Dim mult: health={}, damage={}", new Object[]{mob.getType(), dayMultiplier, dimMultipliers.health, dimMultipliers.damage});
            MobBuffUtil.applyAttributeModifiers(mob, dayMultiplier, dimMultipliers);
        }
        MobBuffUtil.applyVanillaStatusEffects(mob);
        mob.setHealth(mob.getMaxHealth());
    }

    public static double getDayMultiplier(long worldTime) {
        if (!((Boolean)BuffMobsConfig.DayScaling.enabled.get()).booleanValue()) {
            return 1.0;
        }
        long days = worldTime / 24000L;
        long intervals = days / (long)((Integer)BuffMobsConfig.DayScaling.interval.get()).intValue();
        double multiplier = 1.0 + (double)intervals * (Double)BuffMobsConfig.DayScaling.multiplier.get();
        return Math.min(multiplier, (Double)BuffMobsConfig.DayScaling.maxMultiplier.get());
    }

    public static DimensionMultipliers getDimensionMultipliers(Mob mob) {
        BuffMobsConfig.DimensionScaling.DimensionSlot[] slots;
        String dimensionName = mob.level().dimension().location().toString();
        for (BuffMobsConfig.DimensionScaling.DimensionSlot slot : slots = new BuffMobsConfig.DimensionScaling.DimensionSlot[]{BuffMobsConfig.DimensionScaling.slot1, BuffMobsConfig.DimensionScaling.slot2, BuffMobsConfig.DimensionScaling.slot3, BuffMobsConfig.DimensionScaling.slot4, BuffMobsConfig.DimensionScaling.slot5}) {
            String slotDimName = (String)slot.dimensionName.get();
            if (slotDimName.isEmpty() || !slotDimName.equals(dimensionName)) continue;
            DimensionMultipliers multipliers = new DimensionMultipliers((double)((Integer)slot.healthMultiplier.get()).intValue() / 100.0, (double)((Integer)slot.damageMultiplier.get()).intValue() / 100.0, (double)((Integer)slot.speedMultiplier.get()).intValue() / 100.0, (double)((Integer)slot.attackSpeedMultiplier.get()).intValue() / 100.0, ((Integer)slot.armorAddition.get()).intValue(), ((Integer)slot.armorToughnessAddition.get()).intValue());
            BuffMobsMod.LOGGER.debug("Dimension {} has custom scaling: health={}, damage={}", new Object[]{dimensionName, multipliers.health, multipliers.damage});
            return multipliers;
        }
        BuffMobsMod.LOGGER.debug("Dimension {} using default scaling", (Object)dimensionName);
        return new DimensionMultipliers(1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
    }

    public static void refreshInfiniteEffects(Mob mob) {
        if ((Integer)BuffMobsConfig.Effects.duration.get() != -1 || !MobBuffUtil.isValidMob(mob)) {
            return;
        }
        boolean showParticles = (Boolean)BuffMobsConfig.visualEffects.get();
        int infiniteDuration = -1;
        MobBuffUtil.refreshEffect(mob, (Holder<MobEffect>)MobEffects.STRENGTH, (Integer)BuffMobsConfig.Effects.strengthAmplifier.get(), infiniteDuration, showParticles);
        MobBuffUtil.refreshEffect(mob, (Holder<MobEffect>)MobEffects.RESISTANCE, (Integer)BuffMobsConfig.Effects.resistanceAmplifier.get(), infiniteDuration, showParticles);
        if ((Integer)BuffMobsConfig.Effects.regenerationAmplifier.get() > 0 && !mob.getType().is(EntityTypeTags.UNDEAD)) {
            MobBuffUtil.refreshEffect(mob, (Holder<MobEffect>)MobEffects.REGENERATION, (Integer)BuffMobsConfig.Effects.regenerationAmplifier.get(), infiniteDuration, showParticles);
        }
    }

    public static void applyPoisonToPlayer(Player player, int duration) {
        player.addEffect(new MobEffectInstance(MobEffects.POISON, duration * 20, 0));
    }

    public static void applySlownessToPlayer(Player player, int duration) {
        player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, duration * 20, 0));
    }

    public static void applyWitherToPlayer(Player player, int duration) {
        player.addEffect(new MobEffectInstance(MobEffects.WITHER, duration * 20, 0));
    }

    public static boolean isValidMob(Mob mob) {
        boolean isHostileOrNeutral;
        TamableAnimal tameable;
        if (mob.isRemoved() || !mob.isAlive()) {
            return false;
        }
        if (mob instanceof TamableAnimal && (tameable = (TamableAnimal)mob).isTame()) {
            return false;
        }
        boolean bl = isHostileOrNeutral = mob instanceof Enemy || mob.getType().is(EntityTypeTags.RAIDERS) || mob.getType().is(EntityTypeTags.SKELETONS) || MobBuffUtil.isNeutralMob(mob) || MobBuffUtil.hasAttackDamageAttribute(mob);
        if (!isHostileOrNeutral) {
            if (BuffMobsMod.LOGGER.isDebugEnabled()) {
                BuffMobsMod.LOGGER.debug("Mob {} is not hostile/neutral", (Object)mob.getType().toString());
            }
            return false;
        }
        String mobId = mob.getType().toString();
        String modId = ResourceLocation.parse((String)mobId).getNamespace();
        String dimensionName = mob.level().dimension().location().toString();
        boolean validDim = MobBuffUtil.isValidDimension(dimensionName);
        boolean validMod = MobBuffUtil.isValidModId(modId);
        boolean validMob = MobBuffUtil.isValidMobId(mobId);
        if (!validDim && BuffMobsMod.LOGGER.isDebugEnabled()) {
            BuffMobsMod.LOGGER.debug("Mob {} filtered by dimension: {}", (Object)mobId, (Object)dimensionName);
        }
        if (!validMod && BuffMobsMod.LOGGER.isDebugEnabled()) {
            BuffMobsMod.LOGGER.debug("Mob {} filtered by mod: {}", (Object)mobId, (Object)modId);
        }
        if (!validMob && BuffMobsMod.LOGGER.isDebugEnabled()) {
            BuffMobsMod.LOGGER.debug("Mob {} filtered by mob filter", (Object)mobId);
        }
        return validDim && validMod && validMob;
    }

    private static boolean hasAttackDamageAttribute(Mob mob) {
        AttributeInstance attackAttr = mob.getAttribute(Attributes.ATTACK_DAMAGE);
        return attackAttr != null && attackAttr.getBaseValue() > 0.0;
    }

    private static boolean isNeutralMob(Mob mob) {
        String mobId;
        return switch (mobId = mob.getType().toString()) {
            case "minecraft:enderman", "minecraft:piglin", "minecraft:zombified_piglin", "minecraft:iron_golem", "minecraft:spider", "minecraft:cave_spider", "minecraft:wolf", "minecraft:polar_bear", "minecraft:bee", "minecraft:panda", "minecraft:llama", "minecraft:dolphin", "minecraft:trader_llama", "minecraft:slime", "minecraft:magma_cube" -> true;
            default -> false;
        };
    }

    private static void applyAttributeModifiers(Mob mob, double dayMultiplier, DimensionMultipliers dimMultipliers) {
        MobBuffUtil.applyHealthModifier(mob, dayMultiplier, dimMultipliers.health, (Double)BuffMobsConfig.Attributes.healthMultiplier.get());
        MobBuffUtil.applyDamageModifier(mob, dayMultiplier, dimMultipliers.damage, (Double)BuffMobsConfig.Attributes.damageMultiplier.get());
        MobBuffUtil.applySpeedModifier(mob, dayMultiplier, dimMultipliers.speed, (Double)BuffMobsConfig.Attributes.speedMultiplier.get());
        MobBuffUtil.applyAttackSpeedModifier(mob, dayMultiplier, dimMultipliers.attackSpeed, (Double)BuffMobsConfig.Attributes.attackSpeedMultiplier.get());
        MobBuffUtil.applyArmorModifier(mob, dayMultiplier, dimMultipliers.armor, (Double)BuffMobsConfig.Attributes.armorAddition.get());
        MobBuffUtil.applyToughnessModifier(mob, dayMultiplier, dimMultipliers.armorToughness, (Double)BuffMobsConfig.Attributes.armorToughnessAddition.get());
    }

    private static void applyAttributeModifiersWithPreset(Mob mob, double dayMultiplier, MobPresetUtil.PresetMultipliers presetMult) {
        MobBuffUtil.applyHealthModifier(mob, dayMultiplier, 1.0, presetMult.health);
        MobBuffUtil.applyDamageModifier(mob, dayMultiplier, 1.0, presetMult.damage);
        MobBuffUtil.applySpeedModifier(mob, dayMultiplier, 1.0, presetMult.speed);
        MobBuffUtil.applyAttackSpeedModifier(mob, dayMultiplier, 1.0, presetMult.attackSpeed);
        MobBuffUtil.applyArmorModifier(mob, dayMultiplier, 0.0, presetMult.armor);
        MobBuffUtil.applyToughnessModifier(mob, dayMultiplier, 0.0, presetMult.armorToughness);
    }

    private static void applyHealthModifier(Mob mob, double dayMult, double dimMult, double baseMult) {
        double mult = MobBuffUtil.calculateFinalMultiplier(baseMult, dimMult, dayMult);
        AttributeInstance attr = mob.getAttribute(Attributes.MAX_HEALTH);
        if (attr != null) {
            attr.removeModifier(HEALTH_MOD_ID);
            if (mult > 1.0) {
                attr.addPermanentModifier(new AttributeModifier(HEALTH_MOD_ID, mult - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                BuffMobsMod.LOGGER.debug("Applied health mult {} to {}", (Object)mult, (Object)mob.getType());
            }
        }
    }

    private static void applyDamageModifier(Mob mob, double dayMult, double dimMult, double baseMult) {
        double mult = MobBuffUtil.calculateFinalMultiplier(baseMult, dimMult, dayMult);
        AttributeInstance attr = mob.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attr != null) {
            attr.removeModifier(DAMAGE_MOD_ID);
            if (mult > 1.0) {
                attr.addPermanentModifier(new AttributeModifier(DAMAGE_MOD_ID, mult - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
        }
    }

    private static void applySpeedModifier(Mob mob, double dayMult, double dimMult, double baseMult) {
        double mult = MobBuffUtil.calculateFinalMultiplier(baseMult, dimMult, dayMult);
        AttributeInstance attr = mob.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr != null) {
            attr.removeModifier(SPEED_MOD_ID);
            if (mult > 1.0) {
                double cappedMult = Math.min(mult, 2.0);
                double bonus = (cappedMult - 1.0) * 0.3;
                attr.addPermanentModifier(new AttributeModifier(SPEED_MOD_ID, bonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
        }
    }

    private static void applyAttackSpeedModifier(Mob mob, double dayMult, double dimMult, double baseMult) {
        double mult = MobBuffUtil.calculateFinalMultiplier(baseMult, dimMult, dayMult);
        AttributeInstance attr = mob.getAttribute(Attributes.ATTACK_SPEED);
        if (attr != null) {
            attr.removeModifier(ATTACK_SPEED_MOD_ID);
            if (mult > 1.0) {
                double cappedMult = Math.min(mult, 2.5);
                attr.addPermanentModifier(new AttributeModifier(ATTACK_SPEED_MOD_ID, cappedMult - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
        }
    }

    private static void applyArmorModifier(Mob mob, double dayMult, double dimAdd, double baseAdd) {
        double add = MobBuffUtil.calculateFinalAddition(baseAdd, dimAdd, dayMult);
        AttributeInstance attr = mob.getAttribute(Attributes.ARMOR);
        if (attr != null) {
            attr.removeModifier(ARMOR_MOD_ID);
            if (add > 0.0) {
                attr.addPermanentModifier(new AttributeModifier(ARMOR_MOD_ID, add, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    private static void applyToughnessModifier(Mob mob, double dayMult, double dimAdd, double baseAdd) {
        double add = MobBuffUtil.calculateFinalAddition(baseAdd, dimAdd, dayMult);
        AttributeInstance attr = mob.getAttribute(Attributes.ARMOR_TOUGHNESS);
        if (attr != null) {
            attr.removeModifier(TOUGHNESS_MOD_ID);
            if (add > 0.0) {
                attr.addPermanentModifier(new AttributeModifier(TOUGHNESS_MOD_ID, add, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    private static void applyVanillaStatusEffects(Mob mob) {
        int duration = (Integer)BuffMobsConfig.Effects.duration.get() == -1 ? -1 : (Integer)BuffMobsConfig.Effects.duration.get() * 20;
        boolean showParticles = (Boolean)BuffMobsConfig.visualEffects.get();
        MobBuffUtil.addEffect(mob, (Holder<MobEffect>)MobEffects.STRENGTH, (Integer)BuffMobsConfig.Effects.strengthAmplifier.get(), duration, showParticles);
        MobBuffUtil.addEffect(mob, (Holder<MobEffect>)MobEffects.RESISTANCE, (Integer)BuffMobsConfig.Effects.resistanceAmplifier.get(), duration, showParticles);
        if ((Integer)BuffMobsConfig.Effects.regenerationAmplifier.get() > 0 && !mob.getType().is(EntityTypeTags.UNDEAD)) {
            MobBuffUtil.addEffect(mob, (Holder<MobEffect>)MobEffects.REGENERATION, (Integer)BuffMobsConfig.Effects.regenerationAmplifier.get(), duration, showParticles);
        }
    }

    private static void refreshEffect(Mob mob, Holder<MobEffect> effect, int amplifier, int duration, boolean showParticles) {
        if (amplifier <= 0) {
            return;
        }
        MobEffectInstance current = mob.getEffect(effect);
        if (current == null || current.getDuration() < 1200) {
            mob.removeEffect(effect);
            mob.addEffect(new MobEffectInstance(effect, duration, amplifier - 1, false, showParticles, true));
        }
    }

    private static void addEffect(Mob mob, Holder<MobEffect> effect, int amplifier, int duration, boolean showParticles) {
        if (amplifier > 0) {
            mob.addEffect(new MobEffectInstance(effect, duration, amplifier - 1, false, showParticles, true));
        }
    }

    private static boolean isValidDimension(String dimensionName) {
        List blacklist = (List)BuffMobsConfig.DimensionFilter.blacklist.get();
        if (blacklist.contains(dimensionName)) {
            return false;
        }
        if (((Boolean)BuffMobsConfig.DimensionFilter.useWhitelist.get()).booleanValue()) {
            return ((List)BuffMobsConfig.DimensionFilter.whitelist.get()).contains(dimensionName);
        }
        return true;
    }

    private static boolean isValidModId(String modId) {
        List blacklist = (List)BuffMobsConfig.ModIdFilter.blacklist.get();
        if (blacklist.contains(modId)) {
            return false;
        }
        if (((Boolean)BuffMobsConfig.ModIdFilter.useWhitelist.get()).booleanValue()) {
            return ((List)BuffMobsConfig.ModIdFilter.whitelist.get()).contains(modId);
        }
        return true;
    }

    private static boolean isValidMobId(String mobId) {
        List blacklist = (List)BuffMobsConfig.MobFilter.blacklist.get();
        if (blacklist.contains(mobId)) {
            return false;
        }
        if (((Boolean)BuffMobsConfig.MobFilter.useWhitelist.get()).booleanValue()) {
            return ((List)BuffMobsConfig.MobFilter.whitelist.get()).contains(mobId);
        }
        return true;
    }

    public static double calculateFinalMultiplier(double baseMultiplier, double dimensionMultiplier, double dayMultiplier) {
        if (baseMultiplier > 1.0) {
            return baseMultiplier * dimensionMultiplier * dayMultiplier;
        }
        if (dimensionMultiplier > 1.0) {
            return dimensionMultiplier * dayMultiplier;
        }
        return 1.0;
    }

    public static double calculateFinalAddition(double baseAddition, double dimensionAddition, double dayMultiplier) {
        if (baseAddition > 0.0) {
            return (baseAddition + dimensionAddition) * dayMultiplier;
        }
        if (dimensionAddition > 0.0) {
            return dimensionAddition * dayMultiplier;
        }
        return 0.0;
    }

    public static class DimensionMultipliers {
        public final double health;
        public final double damage;
        public final double speed;
        public final double attackSpeed;
        public final double armor;
        public final double armorToughness;

        public DimensionMultipliers(double health, double damage, double speed, double attackSpeed, double armor, double armorToughness) {
            this.health = health;
            this.damage = damage;
            this.speed = speed;
            this.attackSpeed = attackSpeed;
            this.armor = armor;
            this.armorToughness = armorToughness;
        }
    }
}

