/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import java.util.List;
import net.minecraft.world.entity.Mob;

public class MobPresetUtil {
    public static PresetMultipliers getPresetForMob(Mob mob) {
        if (!((Boolean)BuffMobsConfig.MobPresets.enabled.get()).booleanValue()) {
            BuffMobsMod.LOGGER.debug("Mob presets disabled in config");
            return null;
        }
        String mobId = mob.getType().toString();
        String presetName = null;
        BuffMobsMod.LOGGER.debug("Checking preset for mob: {}", (Object)mobId);
        for (String mapping : (List)BuffMobsConfig.MobPresets.mobMapping.get()) {
            String[] parts = mapping.split(":");
            if (parts.length >= 3) {
                String mappedMobId = parts[0] + ":" + parts[1];
                String mappedPreset = parts[2];
                BuffMobsMod.LOGGER.debug("Checking mapping: {} -> {}", (Object)mappedMobId, (Object)mappedPreset);
                if (!mappedMobId.equals(mobId)) continue;
                presetName = mappedPreset;
                BuffMobsMod.LOGGER.debug("Found matching preset: {}", (Object)presetName);
                break;
            }
            BuffMobsMod.LOGGER.warn("Invalid mapping format: '{}'", (Object)mapping);
        }
        if (presetName == null || presetName.isEmpty()) {
            BuffMobsMod.LOGGER.debug("No preset found for mob: {}", (Object)mobId);
            return null;
        }
        BuffMobsConfig.MobPresets.PresetSlot preset = MobPresetUtil.findPresetByName(presetName);
        if (preset == null || ((String)preset.presetName.get()).isEmpty()) {
            BuffMobsMod.LOGGER.warn("Preset '{}' not found for mob '{}'", (Object)presetName, (Object)mobId);
            return null;
        }
        BuffMobsMod.LOGGER.info("Applied preset '{}' to mob '{}': health={}, damage={}", new Object[]{presetName, mobId, preset.healthMultiplier.get(), preset.damageMultiplier.get()});
        return new PresetMultipliers((Double)preset.healthMultiplier.get(), (Double)preset.damageMultiplier.get(), (Double)preset.speedMultiplier.get(), (Double)preset.attackSpeedMultiplier.get(), (Double)preset.armorAddition.get(), (Double)preset.armorToughnessAddition.get());
    }

    private static BuffMobsConfig.MobPresets.PresetSlot findPresetByName(String name) {
        BuffMobsConfig.MobPresets.PresetSlot[] presets;
        for (BuffMobsConfig.MobPresets.PresetSlot preset : presets = new BuffMobsConfig.MobPresets.PresetSlot[]{BuffMobsConfig.MobPresets.preset1, BuffMobsConfig.MobPresets.preset2, BuffMobsConfig.MobPresets.preset3, BuffMobsConfig.MobPresets.preset4, BuffMobsConfig.MobPresets.preset5}) {
            if (!((String)preset.presetName.get()).equals(name)) continue;
            return preset;
        }
        return null;
    }

    public static class PresetMultipliers {
        public final double health;
        public final double damage;
        public final double speed;
        public final double attackSpeed;
        public final double armor;
        public final double armorToughness;

        public PresetMultipliers(double health, double damage, double speed, double attackSpeed, double armor, double armorToughness) {
            this.health = health;
            this.damage = damage;
            this.speed = speed;
            this.attackSpeed = attackSpeed;
            this.armor = armor;
            this.armorToughness = armorToughness;
        }
    }
}

