/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.util.MeleeWeaponManager;
import com.khotyz.buffmobs.util.RangedBehaviorMode;
import com.khotyz.buffmobs.util.TacticalRetreatGoal;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RangedMobAIManager {
    private static final Map<UUID, MobState> MOB_STATES = new HashMap<UUID, MobState>();
    private static final double MELEE_SPEED_MULTIPLIER = 1.3;
    private static final int SWITCH_COOLDOWN = 10;
    private static final double MELEE_ATTACK_RANGE = 3.0;
    private static Field goalSelectorField;
    private static Field goalsField;

    public static void initializeMob(Mob mob) {
        if (!((Boolean)BuffMobsConfig.RangedMeleeSwitching.enabled.get()).booleanValue()) {
            return;
        }
        if (!RangedMobAIManager.isRangedMob(mob)) {
            return;
        }
        if (MOB_STATES.containsKey(mob.getUUID())) {
            return;
        }
        MobState state = new MobState();
        state.originalWeapon = mob.getItemInHand(InteractionHand.MAIN_HAND).copy();
        RangedBehaviorMode configMode = (RangedBehaviorMode)((Object)BuffMobsConfig.RangedMeleeSwitching.behaviorMode.get());
        state.behaviorMode = configMode == RangedBehaviorMode.RANDOM ? (mob.getRandom().nextBoolean() ? RangedBehaviorMode.MELEE : RangedBehaviorMode.RETREAT) : configMode;
        MOB_STATES.put(mob.getUUID(), state);
        if (state.behaviorMode == RangedBehaviorMode.RETREAT) {
            RangedMobAIManager.setupRetreatMode(mob, state);
        } else {
            RangedMobAIManager.disableRangedGoals(mob);
        }
        BuffMobsMod.LOGGER.info("Initialized {} with behavior mode: {}", (Object)mob.getType(), (Object)state.behaviorMode);
    }

    public static void updateMobBehavior(Mob mob) {
        if (!((Boolean)BuffMobsConfig.RangedMeleeSwitching.enabled.get()).booleanValue()) {
            return;
        }
        if (!RangedMobAIManager.isRangedMob(mob)) {
            return;
        }
        MobState state = MOB_STATES.get(mob.getUUID());
        if (state == null) {
            RangedMobAIManager.initializeMob(mob);
            return;
        }
        Player target = mob.level().getNearestPlayer((Entity)mob, 32.0);
        if (target == null || target.isSpectator() || target.isCreative() || !target.isAlive()) {
            if (state.inMeleeMode) {
                RangedMobAIManager.switchToRangedMode(mob, state);
            }
            return;
        }
        double distance = mob.distanceTo((Entity)target);
        double switchDistance = (Double)BuffMobsConfig.RangedMeleeSwitching.switchDistance.get();
        long currentTime = mob.level().getGameTime();
        if (state.behaviorMode == RangedBehaviorMode.MELEE) {
            if (currentTime - state.lastSwitchTime < 10L) {
                if (state.inMeleeMode) {
                    RangedMobAIManager.handleMeleeAttack(mob, target, state);
                }
                return;
            }
            if (!state.inMeleeMode && distance <= switchDistance) {
                RangedMobAIManager.switchToMeleeMode(mob, state);
            } else if (state.inMeleeMode && distance > switchDistance + 2.0) {
                RangedMobAIManager.switchToRangedMode(mob, state);
            } else if (state.inMeleeMode) {
                RangedMobAIManager.handleMeleeAttack(mob, target, state);
            }
        } else if (state.behaviorMode == RangedBehaviorMode.RETREAT && mob.getTarget() != target) {
            mob.setTarget((LivingEntity)target);
        }
    }

    private static void setupRetreatMode(Mob mob, MobState state) {
        RangedMobAIManager.removeMeleeGoals(mob);
        if (state.retreatGoal == null) {
            double retreatDistance = (Double)BuffMobsConfig.RangedMeleeSwitching.switchDistance.get();
            double retreatSpeed = (Double)BuffMobsConfig.RangedMeleeSwitching.retreatSpeed.get();
            int retreatDuration = (Integer)BuffMobsConfig.RangedMeleeSwitching.retreatDuration.get();
            state.retreatGoal = new TacticalRetreatGoal(mob, retreatDistance, retreatSpeed, retreatDuration);
            RangedMobAIManager.addGoal(mob, 0, state.retreatGoal);
            BuffMobsMod.LOGGER.info("Added TacticalRetreatGoal to {} (distance: {}, speed: {})", new Object[]{mob.getType(), retreatDistance, retreatSpeed});
        }
    }

    private static void removeMeleeGoals(Mob mob) {
        try {
            GoalSelector selector = (GoalSelector)goalSelectorField.get(mob);
            Set goals = (Set)goalsField.get(selector);
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            for (WrappedGoal prioritizedGoal : goals) {
                Goal goal = prioritizedGoal.getGoal();
                if (!(goal instanceof MeleeAttackGoal) && !goal.getClass().getSimpleName().contains("MeleeAttack")) continue;
                toRemove.add(goal);
            }
            for (Goal goal : toRemove) {
                selector.removeGoal(goal);
                BuffMobsMod.LOGGER.info("Removed melee goal {} from {}", (Object)goal.getClass().getSimpleName(), (Object)mob.getType());
            }
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to remove melee goals", (Throwable)e);
        }
    }

    private static void handleMeleeAttack(Mob mob, Player target, MobState state) {
        double distance;
        if (mob.getTarget() != target) {
            mob.setTarget((LivingEntity)target);
        }
        if ((distance = (double)mob.distanceTo((Entity)target)) > 3.0) {
            mob.getNavigation().moveTo((Entity)target, 1.3);
        } else {
            mob.getNavigation().stop();
            Vec3 targetPos = new Vec3(target.getX(), target.getEyeY(), target.getZ());
            mob.lookAt(EntityAnchorArgument.Anchor.EYES, targetPos);
            mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
            long currentTime = mob.level().getGameTime();
            if (currentTime - state.lastAttackTime >= 20L) {
                RangedMobAIManager.performMeleeAttack(mob, (LivingEntity)target);
                state.lastAttackTime = currentTime;
            }
        }
    }

    private static void performMeleeAttack(Mob mob, LivingEntity target) {
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 mobPos = new Vec3(mob.getX(), mob.getY(), mob.getZ());
            Vec3 targetPos = new Vec3(target.getX(), target.getY(), target.getZ());
            Vec3 vec3d = targetPos.subtract(mobPos).normalize();
            mob.setDeltaMovement(vec3d.x * 0.1, 0.1, vec3d.z * 0.1);
            mob.hurtMarked = true;
            mob.doHurtTarget(serverWorld, (Entity)target);
            mob.swing(InteractionHand.MAIN_HAND, true);
            BuffMobsMod.LOGGER.debug("{} performed melee attack on {}", (Object)mob.getType(), (Object)target.getName().getString());
        }
    }

    private static void switchToMeleeMode(Mob mob, MobState state) {
        Player target;
        ItemStack meleeWeapon = MeleeWeaponManager.generateMeleeWeapon(mob);
        mob.setItemSlot(EquipmentSlot.MAINHAND, meleeWeapon);
        mob.setItemInHand(InteractionHand.MAIN_HAND, meleeWeapon);
        RangedMobAIManager.disableRangedGoals(mob);
        if (state.meleeGoal == null) {
            if (mob instanceof PathfinderMob) {
                PathfinderMob pathAware = (PathfinderMob)mob;
                state.meleeGoal = new MeleeAttackGoal(pathAware, 1.3, false);
                RangedMobAIManager.addGoal(mob, 0, state.meleeGoal);
            } else {
                state.meleeGoal = new CustomMeleeGoal(mob);
                RangedMobAIManager.addGoal(mob, 0, state.meleeGoal);
            }
        }
        if ((target = mob.level().getNearestPlayer((Entity)mob, 32.0)) != null) {
            mob.setTarget((LivingEntity)target);
        }
        state.inMeleeMode = true;
        state.inRetreatMode = false;
        state.lastSwitchTime = mob.level().getGameTime();
        state.lastAttackTime = 0L;
        BuffMobsMod.LOGGER.info("Switched {} to MELEE mode", (Object)mob.getType());
    }

    private static void switchToRangedMode(Mob mob, MobState state) {
        ItemStack rangedWeapon = state.originalWeapon.isEmpty() ? RangedMobAIManager.getDefaultRangedWeapon(mob) : state.originalWeapon.copy();
        mob.setItemSlot(EquipmentSlot.MAINHAND, rangedWeapon);
        mob.setItemInHand(InteractionHand.MAIN_HAND, rangedWeapon);
        if (state.meleeGoal != null) {
            RangedMobAIManager.removeGoal(mob, state.meleeGoal);
            state.meleeGoal = null;
        }
        RangedMobAIManager.enableRangedGoals(mob);
        state.inMeleeMode = false;
        state.inRetreatMode = false;
        state.lastSwitchTime = mob.level().getGameTime();
        BuffMobsMod.LOGGER.info("Switched {} to RANGED mode", (Object)mob.getType());
    }

    private static void disableRangedGoals(Mob mob) {
        try {
            GoalSelector selector = (GoalSelector)goalSelectorField.get(mob);
            Set goals = (Set)goalsField.get(selector);
            for (WrappedGoal prioritizedGoal : goals) {
                Goal goal = prioritizedGoal.getGoal();
                if (!(goal instanceof RangedBowAttackGoal) && !(goal instanceof RangedCrossbowAttackGoal)) continue;
                prioritizedGoal.stop();
            }
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to disable ranged goals", (Throwable)e);
        }
    }

    private static void enableRangedGoals(Mob mob) {
        try {
            GoalSelector selector = (GoalSelector)goalSelectorField.get(mob);
            selector.tick();
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to enable ranged goals", (Throwable)e);
        }
    }

    private static void addGoal(Mob mob, int priority, Goal goal) {
        try {
            GoalSelector selector = (GoalSelector)goalSelectorField.get(mob);
            selector.addGoal(priority, goal);
            BuffMobsMod.LOGGER.info("Added goal {} with priority {} to {}", new Object[]{goal.getClass().getSimpleName(), priority, mob.getType()});
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to add goal to mob", (Throwable)e);
        }
    }

    private static void removeGoal(Mob mob, Goal goal) {
        try {
            GoalSelector selector = (GoalSelector)goalSelectorField.get(mob);
            selector.removeGoal(goal);
            BuffMobsMod.LOGGER.debug("Removed goal {} from {}", (Object)goal.getClass().getSimpleName(), (Object)mob.getType());
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to remove goal from mob", (Throwable)e);
        }
    }

    private static ItemStack getDefaultRangedWeapon(Mob mob) {
        if (mob instanceof AbstractSkeleton) {
            return new ItemStack((ItemLike)Items.BOW);
        }
        if (mob instanceof Piglin || mob instanceof Pillager) {
            return new ItemStack((ItemLike)Items.CROSSBOW);
        }
        return ItemStack.EMPTY;
    }

    public static boolean isRangedMob(Mob mob) {
        String mobId = mob.getType().toString();
        if (((List)BuffMobsConfig.RangedMeleeSwitching.customRangedMobs.get()).contains(mobId)) {
            return true;
        }
        return mob instanceof AbstractSkeleton || mob instanceof Piglin || mob instanceof Pillager;
    }

    public static boolean isInMeleeMode(Mob mob) {
        MobState state = MOB_STATES.get(mob.getUUID());
        return state != null && state.inMeleeMode;
    }

    public static void cleanup(Mob mob) {
        MOB_STATES.remove(mob.getUUID());
    }

    static {
        try {
            goalSelectorField = Mob.class.getDeclaredField("goalSelector");
            goalSelectorField.setAccessible(true);
            goalsField = GoalSelector.class.getDeclaredField("availableGoals");
            goalsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            BuffMobsMod.LOGGER.error("Failed to access goalSelector field", (Throwable)e);
        }
    }

    private static class MobState {
        boolean inMeleeMode = false;
        boolean inRetreatMode = false;
        RangedBehaviorMode behaviorMode = RangedBehaviorMode.MELEE;
        ItemStack originalWeapon = ItemStack.EMPTY;
        long lastSwitchTime = 0L;
        long lastAttackTime = 0L;
        Goal meleeGoal = null;
        TacticalRetreatGoal retreatGoal = null;

        private MobState() {
        }
    }

    private static class CustomMeleeGoal
    extends Goal {
        private final Mob mob;

        public CustomMeleeGoal(Mob mob) {
            this.mob = mob;
        }

        public boolean canUse() {
            LivingEntity target = this.mob.getTarget();
            return target != null && target.isAlive() && (double)this.mob.distanceTo((Entity)target) <= 8.0;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void tick() {
            Level level;
            LivingEntity target = this.mob.getTarget();
            if (target != null && (level = this.mob.level()) instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                this.mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
                double distance = this.mob.distanceTo((Entity)target);
                if (distance > 3.0) {
                    this.mob.getNavigation().moveTo((Entity)target, 1.3);
                } else {
                    this.mob.getNavigation().stop();
                    if (this.mob.tickCount % 20 == 0) {
                        this.mob.doHurtTarget(serverWorld, (Entity)target);
                        this.mob.swing(InteractionHand.MAIN_HAND, true);
                    }
                }
            }
        }
    }
}

