/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class TacticalRetreatGoal
extends Goal {
    private final Mob mob;
    private final double retreatDistance;
    private final double retreatSpeed;
    private final int retreatDuration;
    private LivingEntity target;
    private Path retreatPath;
    private int retreatTimer;
    private int cooldownTimer;
    private static final int COOLDOWN_TIME = 20;

    public TacticalRetreatGoal(Mob mob, double retreatDistance, double retreatSpeed, int retreatDuration) {
        this.mob = mob;
        this.retreatDistance = retreatDistance;
        this.retreatSpeed = retreatSpeed;
        this.retreatDuration = retreatDuration;
        this.retreatTimer = 0;
        this.cooldownTimer = 0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        double distanceToTarget = this.mob.distanceTo((Entity)this.target);
        if (distanceToTarget > this.retreatDistance) {
            return false;
        }
        Vec3 retreatPos = this.findRetreatPosition();
        if (retreatPos == null) {
            return false;
        }
        PathNavigation navigation = this.mob.getNavigation();
        this.retreatPath = navigation.createPath(retreatPos.x, retreatPos.y, retreatPos.z, 0);
        return this.retreatPath != null;
    }

    public boolean canContinueToUse() {
        double safeDistanceSqr;
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        if (this.retreatTimer >= this.retreatDuration) {
            return false;
        }
        double distanceToTarget = this.mob.distanceTo((Entity)this.target);
        return distanceToTarget < (safeDistanceSqr = this.retreatDistance + 2.0);
    }

    public void start() {
        if (this.retreatPath != null) {
            this.mob.getNavigation().moveTo(this.retreatPath, this.retreatSpeed);
        }
        this.retreatTimer = 0;
        BuffMobsMod.LOGGER.debug("{} starting retreat from {}", (Object)this.mob.getType(), (Object)(this.target != null ? this.target.getName().getString() : "unknown"));
    }

    public void stop() {
        this.retreatTimer = 0;
        this.cooldownTimer = 20;
        this.target = null;
        this.retreatPath = null;
    }

    public void tick() {
        ++this.retreatTimer;
        if (this.target != null) {
            Vec3 retreatPos;
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            if ((this.mob.getNavigation().isDone() || this.retreatTimer % 5 == 0) && (retreatPos = this.findRetreatPosition()) != null) {
                this.mob.getNavigation().moveTo(retreatPos.x, retreatPos.y, retreatPos.z, this.retreatSpeed);
            }
        }
    }

    private Vec3 findRetreatPosition() {
        if (this.target == null) {
            return null;
        }
        Vec3 mobPos = this.mob.position();
        Vec3 targetPos = this.target.position();
        Vec3 awayFromTarget = mobPos.subtract(targetPos).normalize();
        Mob mob = this.mob;
        if (mob instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            for (int distance = 10; distance >= 6; --distance) {
                Vec3 potentialPos = mobPos.add(awayFromTarget.scale((double)distance));
                Vec3 validPos = DefaultRandomPos.getPosTowards((PathfinderMob)pathfinderMob, (int)8, (int)5, (Vec3)Vec3.atBottomCenterOf((Vec3i)this.mob.blockPosition().offset((int)(awayFromTarget.x * (double)distance), 0, (int)(awayFromTarget.z * (double)distance))), (double)1.5707963267948966);
                if (validPos == null) continue;
                return validPos;
            }
            Vec3 fallback = DefaultRandomPos.getPosAway((PathfinderMob)pathfinderMob, (int)8, (int)5, (Vec3)targetPos);
            if (fallback != null) {
                return fallback;
            }
        }
        return mobPos.add(awayFromTarget.scale(8.0));
    }

    public void resetCooldown() {
        this.cooldownTimer = 0;
    }
}

