/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.util.MeleeWeaponManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1366;
import net.minecraft.class_1380;
import net.minecraft.class_1381;
import net.minecraft.class_1383;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4135;
import net.minecraft.class_4836;
import net.minecraft.class_7923;

public class RangedMobAIManager {
    private static final Map<UUID, MobState> MOB_STATES = new HashMap<UUID, MobState>();
    private static final double MELEE_SPEED_MULTIPLIER = 1.3;
    private static final int SWITCH_COOLDOWN = 40;
    private static final double MELEE_ATTACK_RANGE = 3.0;
    private static Field goalSelectorField;
    private static Field goalsField;

    public static void initializeMob(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.rangedMeleeSwitching.enabled) {
            return;
        }
        if (!RangedMobAIManager.isRangedMob(mob)) {
            return;
        }
        if (MOB_STATES.containsKey(mob.method_5667())) {
            return;
        }
        MobState state = new MobState();
        state.originalWeapon = mob.method_5998(class_1268.field_5808).method_7972();
        MOB_STATES.put(mob.method_5667(), state);
        RangedMobAIManager.disableRangedGoals(mob);
    }

    public static void updateMobBehavior(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.rangedMeleeSwitching.enabled) {
            return;
        }
        if (!RangedMobAIManager.isRangedMob(mob)) {
            return;
        }
        MobState state = MOB_STATES.get(mob.method_5667());
        if (state == null) {
            RangedMobAIManager.initializeMob(mob);
            return;
        }
        class_1657 target = mob.method_37908().method_18460((class_1297)mob, 32.0);
        if (target == null || target.method_7325() || target.method_68878() || !target.method_5805()) {
            if (state.inMeleeMode) {
                RangedMobAIManager.switchToRangedMode(mob, state);
            }
            return;
        }
        double distance = mob.method_5739((class_1297)target);
        double switchDistance = BuffMobsMod.CONFIG.rangedMeleeSwitching.switchDistance;
        long currentTime = mob.method_37908().method_8510();
        if (currentTime - state.lastSwitchTime < 40L) {
            if (state.inMeleeMode) {
                RangedMobAIManager.handleMeleeAttack(mob, target, state);
            }
            return;
        }
        if (!state.inMeleeMode && distance <= switchDistance) {
            RangedMobAIManager.switchToMeleeMode(mob, state);
        } else if (state.inMeleeMode && distance > switchDistance + 2.0) {
            RangedMobAIManager.switchToRangedMode(mob, state);
        } else if (state.inMeleeMode) {
            RangedMobAIManager.handleMeleeAttack(mob, target, state);
        }
    }

    private static void handleMeleeAttack(class_1308 mob, class_1657 target, MobState state) {
        double distance;
        if (mob.method_5968() != target) {
            mob.method_5980((class_1309)target);
        }
        if ((distance = (double)mob.method_5739((class_1297)target)) > 3.0) {
            mob.method_5942().method_6335((class_1297)target, 1.3);
        } else {
            mob.method_5942().method_6340();
            mob.method_5702(class_2183.class_2184.field_9851, target.method_19538());
            mob.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
            long currentTime = mob.method_37908().method_8510();
            if (currentTime - state.lastAttackTime >= 20L) {
                RangedMobAIManager.performMeleeAttack(mob, (class_1309)target);
                state.lastAttackTime = currentTime;
            }
        }
    }

    private static void performMeleeAttack(class_1308 mob, class_1309 target) {
        class_1937 class_19372;
        if (!mob.method_37908().field_9236 && (class_19372 = mob.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 vec3d = target.method_19538().method_1020(mob.method_19538()).method_1029();
            mob.method_18800(vec3d.field_1352 * 0.1, 0.1, vec3d.field_1350 * 0.1);
            mob.field_6037 = true;
            mob.method_6121(serverWorld, (class_1297)target);
            mob.method_23667(class_1268.field_5808, true);
            BuffMobsMod.LOGGER.debug("{} performed melee attack on {}", (Object)mob.method_5864(), (Object)target.method_5477().getString());
        }
    }

    private static void switchToMeleeMode(class_1308 mob, MobState state) {
        class_1657 target;
        class_1799 meleeWeapon = MeleeWeaponManager.generateMeleeWeapon(mob);
        mob.method_5673(class_1304.field_6173, meleeWeapon);
        mob.method_6122(class_1268.field_5808, meleeWeapon);
        RangedMobAIManager.disableRangedGoals(mob);
        if (state.meleeGoal == null) {
            if (mob instanceof class_1314) {
                class_1314 pathAware = (class_1314)mob;
                state.meleeGoal = new class_1366(pathAware, 1.3, false);
                RangedMobAIManager.addGoal(mob, 0, state.meleeGoal);
            } else {
                state.meleeGoal = new CustomMeleeGoal(mob);
                RangedMobAIManager.addGoal(mob, 0, state.meleeGoal);
            }
        }
        if ((target = mob.method_37908().method_18460((class_1297)mob, 32.0)) != null) {
            mob.method_5980((class_1309)target);
        }
        state.inMeleeMode = true;
        state.lastSwitchTime = mob.method_37908().method_8510();
        state.lastAttackTime = 0L;
        BuffMobsMod.LOGGER.info("Switched {} to MELEE mode", (Object)mob.method_5864());
    }

    private static void switchToRangedMode(class_1308 mob, MobState state) {
        class_1799 rangedWeapon = state.originalWeapon.method_7960() ? RangedMobAIManager.getDefaultRangedWeapon(mob) : state.originalWeapon.method_7972();
        mob.method_5673(class_1304.field_6173, rangedWeapon);
        mob.method_6122(class_1268.field_5808, rangedWeapon);
        if (state.meleeGoal != null) {
            RangedMobAIManager.removeGoal(mob, state.meleeGoal);
            state.meleeGoal = null;
        }
        RangedMobAIManager.enableRangedGoals(mob);
        state.inMeleeMode = false;
        state.lastSwitchTime = mob.method_37908().method_8510();
        BuffMobsMod.LOGGER.info("Switched {} to RANGED mode", (Object)mob.method_5864());
    }

    private static void disableRangedGoals(class_1308 mob) {
        try {
            class_1355 selector = (class_1355)goalSelectorField.get(mob);
            Set goals = (Set)goalsField.get(selector);
            for (class_4135 prioritizedGoal : goals) {
                class_1352 goal = prioritizedGoal.method_19058();
                if (!(goal instanceof class_1380) && !(goal instanceof class_1383) && !(goal instanceof class_1381)) continue;
                prioritizedGoal.method_6270();
            }
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to disable ranged goals", (Throwable)e);
        }
    }

    private static void enableRangedGoals(class_1308 mob) {
        try {
            class_1355 selector = (class_1355)goalSelectorField.get(mob);
            selector.method_6275();
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to enable ranged goals", (Throwable)e);
        }
    }

    private static void addGoal(class_1308 mob, int priority, class_1352 goal) {
        try {
            class_1355 selector = (class_1355)goalSelectorField.get(mob);
            selector.method_6277(priority, goal);
            BuffMobsMod.LOGGER.debug("Added melee goal to {}", (Object)mob.method_5864());
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to add goal to mob", (Throwable)e);
        }
    }

    private static void removeGoal(class_1308 mob, class_1352 goal) {
        try {
            class_1355 selector = (class_1355)goalSelectorField.get(mob);
            selector.method_6280(goal);
            BuffMobsMod.LOGGER.debug("Removed melee goal from {}", (Object)mob.method_5864());
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.warn("Failed to remove goal from mob", (Throwable)e);
        }
    }

    private static class_1799 getDefaultRangedWeapon(class_1308 mob) {
        if (mob instanceof class_1613 || mob instanceof class_1627 || mob instanceof class_1639) {
            return new class_1799((class_1935)class_1802.field_8102);
        }
        if (mob instanceof class_4836 || mob instanceof class_1604) {
            return new class_1799((class_1935)class_1802.field_8399);
        }
        return class_1799.field_8037;
    }

    public static boolean isRangedMob(class_1308 mob) {
        String mobId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        if (BuffMobsMod.CONFIG.rangedMeleeSwitching.customRangedMobs.contains(mobId)) {
            return true;
        }
        return mob instanceof class_1613 || mob instanceof class_1627 || mob instanceof class_1639 || mob instanceof class_4836 || mob instanceof class_1604;
    }

    public static boolean isInMeleeMode(class_1308 mob) {
        MobState state = MOB_STATES.get(mob.method_5667());
        return state != null && state.inMeleeMode;
    }

    public static void cleanup(class_1308 mob) {
        MOB_STATES.remove(mob.method_5667());
    }

    static {
        try {
            goalSelectorField = class_1308.class.getDeclaredField("goalSelector");
            goalSelectorField.setAccessible(true);
            goalsField = class_1355.class.getDeclaredField("goals");
            goalsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            BuffMobsMod.LOGGER.error("Failed to access goalSelector field", (Throwable)e);
        }
    }

    private static class MobState {
        boolean inMeleeMode = false;
        class_1799 originalWeapon = class_1799.field_8037;
        long lastSwitchTime = 0L;
        long lastAttackTime = 0L;
        class_1352 meleeGoal = null;

        private MobState() {
        }
    }

    private static class CustomMeleeGoal
    extends class_1352 {
        private final class_1308 mob;

        public CustomMeleeGoal(class_1308 mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            class_1309 target = this.mob.method_5968();
            return target != null && target.method_5805() && (double)this.mob.method_5739((class_1297)target) <= 8.0;
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6268() {
            class_1937 class_19372;
            class_1309 target = this.mob.method_5968();
            if (target != null && (class_19372 = this.mob.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                this.mob.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                double distance = this.mob.method_5739((class_1297)target);
                if (distance > 3.0) {
                    this.mob.method_5942().method_6335((class_1297)target, 1.3);
                } else {
                    this.mob.method_5942().method_6340();
                    if (this.mob.field_6012 % 20 == 0) {
                        this.mob.method_6121(serverWorld, (class_1297)target);
                        this.mob.method_23667(class_1268.field_5808, true);
                    }
                }
            }
        }
    }
}

