/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.effects.CustomStatusEffects;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1308;
import net.minecraft.class_1321;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_3483;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class MobBuffUtil {
    public static void applyBuffs(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.enabled || !MobBuffUtil.isValidMob(mob)) {
            return;
        }
        double dayMultiplier = MobBuffUtil.getDayMultiplier(mob.method_37908().method_8532());
        DimensionMultipliers dimMultipliers = MobBuffUtil.getDimensionMultipliers(mob);
        MobBuffUtil.applyCustomStatusEffects(mob, dayMultiplier, dimMultipliers);
        MobBuffUtil.applyVanillaStatusEffects(mob);
        mob.method_6033(mob.method_6063());
    }

    public static double getDayMultiplier(long worldTime) {
        if (!BuffMobsMod.CONFIG.dayScaling.enabled) {
            return 1.0;
        }
        long days = worldTime / 24000L;
        long intervals = days / (long)BuffMobsMod.CONFIG.dayScaling.interval;
        double multiplier = 1.0 + (double)intervals * BuffMobsMod.CONFIG.dayScaling.multiplier;
        return Math.min(multiplier, BuffMobsMod.CONFIG.dayScaling.maxMultiplier);
    }

    public static DimensionMultipliers getDimensionMultipliers(class_1308 mob) {
        BuffMobsConfig.DimensionScaling.DimensionSlot[] slots;
        String dimensionName = mob.method_37908().method_27983().method_29177().toString();
        for (BuffMobsConfig.DimensionScaling.DimensionSlot slot : slots = new BuffMobsConfig.DimensionScaling.DimensionSlot[]{BuffMobsMod.CONFIG.dimensionScaling.slot1, BuffMobsMod.CONFIG.dimensionScaling.slot2, BuffMobsMod.CONFIG.dimensionScaling.slot3, BuffMobsMod.CONFIG.dimensionScaling.slot4, BuffMobsMod.CONFIG.dimensionScaling.slot5}) {
            if (slot.dimensionName.isEmpty() || !slot.dimensionName.equals(dimensionName)) continue;
            return new DimensionMultipliers((double)slot.healthMultiplier / 100.0, (double)slot.damageMultiplier / 100.0, (double)slot.speedMultiplier / 100.0, (double)slot.attackSpeedMultiplier / 100.0, slot.armorAddition, slot.armorToughnessAddition);
        }
        return new DimensionMultipliers(1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
    }

    public static void refreshInfiniteEffects(class_1308 mob) {
        if (BuffMobsMod.CONFIG.effects.duration != -1 || !MobBuffUtil.isValidMob(mob)) {
            return;
        }
        boolean showParticles = BuffMobsMod.CONFIG.visualEffects;
        int infiniteDuration = -1;
        MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5910, BuffMobsMod.CONFIG.effects.strengthAmplifier, infiniteDuration, showParticles);
        MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5904, BuffMobsMod.CONFIG.effects.speedAmplifier, infiniteDuration, showParticles);
        MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5907, BuffMobsMod.CONFIG.effects.resistanceAmplifier, infiniteDuration, showParticles);
        if (BuffMobsMod.CONFIG.effects.regenerationAmplifier > 0 && !mob.method_5864().method_20210(class_3483.field_46232)) {
            MobBuffUtil.refreshEffect(mob, (class_6880<class_1291>)class_1294.field_5924, BuffMobsMod.CONFIG.effects.regenerationAmplifier, infiniteDuration, showParticles);
        }
    }

    public static void applyPoisonToPlayer(class_1657 player, int duration) {
        player.method_6092(new class_1293(class_1294.field_5899, duration * 20, 0));
    }

    public static void applySlownessToPlayer(class_1657 player, int duration) {
        player.method_6092(new class_1293(class_1294.field_5909, duration * 20, 0));
    }

    public static void applyWitherToPlayer(class_1657 player, int duration) {
        player.method_6092(new class_1293(class_1294.field_5920, duration * 20, 0));
    }

    public static boolean isValidMob(class_1308 mob) {
        class_1321 tameable;
        if (!(mob instanceof class_1588)) {
            return false;
        }
        if (mob instanceof class_1321 && (tameable = (class_1321)mob).method_6181()) {
            return false;
        }
        String mobId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        String modId = class_7923.field_41177.method_10221((Object)mob.method_5864()).method_12836();
        String dimensionName = mob.method_37908().method_27983().method_29177().toString();
        return MobBuffUtil.isValidDimension(dimensionName) && MobBuffUtil.isValidModId(modId) && MobBuffUtil.isValidMobId(mobId);
    }

    private static void applyCustomStatusEffects(class_1308 mob, double dayMultiplier, DimensionMultipliers dimMultipliers) {
        double toughnessAdd;
        double armorAdd;
        double attackSpeedMult;
        double speedMult;
        double damageMult;
        int duration = BuffMobsMod.CONFIG.effects.duration == -1 ? -1 : BuffMobsMod.CONFIG.effects.duration * 20;
        boolean showParticles = BuffMobsMod.CONFIG.visualEffects;
        double healthMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.healthMultiplier, dimMultipliers.health, dayMultiplier);
        if (healthMult > 1.0) {
            int amplifier = Math.min(255, (int)Math.floor(healthMult - 1.0));
            mob.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)CustomStatusEffects.MOB_HEALTH_BOOST), duration, amplifier, false, showParticles, true));
        }
        if ((damageMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.damageMultiplier, dimMultipliers.damage, dayMultiplier)) > 1.0) {
            int amplifier = Math.min(255, (int)Math.floor(damageMult - 1.0));
            mob.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)CustomStatusEffects.MOB_DAMAGE_BOOST), duration, amplifier, false, showParticles, true));
        }
        if ((speedMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.speedMultiplier, dimMultipliers.speed, dayMultiplier)) > 1.0) {
            int amplifier = Math.min(255, (int)Math.floor(speedMult - 1.0));
            mob.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)CustomStatusEffects.MOB_SPEED_BOOST), duration, amplifier, false, showParticles, true));
        }
        if ((attackSpeedMult = MobBuffUtil.calculateFinalMultiplier(BuffMobsMod.CONFIG.attributes.attackSpeedMultiplier, dimMultipliers.attackSpeed, dayMultiplier)) > 1.0) {
            int amplifier = Math.min(255, (int)Math.floor(attackSpeedMult - 1.0));
            mob.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)CustomStatusEffects.MOB_ATTACK_SPEED_BOOST), duration, amplifier, false, showParticles, true));
        }
        if ((armorAdd = MobBuffUtil.calculateFinalAddition(BuffMobsMod.CONFIG.attributes.armorAddition, dimMultipliers.armor, dayMultiplier)) > 0.0) {
            int amplifier = Math.min(255, (int)Math.floor(armorAdd));
            mob.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)CustomStatusEffects.MOB_ARMOR_BOOST), duration, amplifier, false, showParticles, true));
        }
        if ((toughnessAdd = MobBuffUtil.calculateFinalAddition(BuffMobsMod.CONFIG.attributes.armorToughnessAddition, dimMultipliers.armorToughness, dayMultiplier)) > 0.0) {
            int amplifier = Math.min(255, (int)Math.floor(toughnessAdd));
            mob.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)CustomStatusEffects.MOB_TOUGHNESS_BOOST), duration, amplifier, false, showParticles, true));
        }
    }

    private static void applyVanillaStatusEffects(class_1308 mob) {
        int duration = BuffMobsMod.CONFIG.effects.duration == -1 ? -1 : BuffMobsMod.CONFIG.effects.duration * 20;
        boolean showParticles = BuffMobsMod.CONFIG.visualEffects;
        MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5910, BuffMobsMod.CONFIG.effects.strengthAmplifier, duration, showParticles);
        MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5904, BuffMobsMod.CONFIG.effects.speedAmplifier, duration, showParticles);
        MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5907, BuffMobsMod.CONFIG.effects.resistanceAmplifier, duration, showParticles);
        if (BuffMobsMod.CONFIG.effects.regenerationAmplifier > 0 && !mob.method_5864().method_20210(class_3483.field_46232)) {
            MobBuffUtil.addEffect(mob, (class_6880<class_1291>)class_1294.field_5924, BuffMobsMod.CONFIG.effects.regenerationAmplifier, duration, showParticles);
        }
    }

    private static void refreshEffect(class_1308 mob, class_6880<class_1291> effect, int amplifier, int duration, boolean showParticles) {
        if (amplifier <= 0) {
            return;
        }
        class_1293 current = mob.method_6112(effect);
        if (current == null || current.method_5584() < 1200) {
            mob.method_6016(effect);
            mob.method_6092(new class_1293(effect, duration, amplifier - 1, false, showParticles, true));
        }
    }

    private static void addEffect(class_1308 mob, class_6880<class_1291> effect, int amplifier, int duration, boolean showParticles) {
        if (amplifier > 0) {
            mob.method_6092(new class_1293(effect, duration, amplifier - 1, false, showParticles, true));
        }
    }

    private static boolean isValidDimension(String dimensionName) {
        List<String> blacklist = BuffMobsMod.CONFIG.dimensionFilter.blacklist;
        if (blacklist.contains(dimensionName)) {
            return false;
        }
        if (BuffMobsMod.CONFIG.dimensionFilter.useWhitelist) {
            return BuffMobsMod.CONFIG.dimensionFilter.whitelist.contains(dimensionName);
        }
        return true;
    }

    private static boolean isValidModId(String modId) {
        List<String> blacklist = BuffMobsMod.CONFIG.modidFilter.blacklist;
        if (blacklist.contains(modId)) {
            return false;
        }
        if (BuffMobsMod.CONFIG.modidFilter.useWhitelist) {
            return BuffMobsMod.CONFIG.modidFilter.whitelist.contains(modId);
        }
        return true;
    }

    private static boolean isValidMobId(String mobId) {
        List<String> blacklist = BuffMobsMod.CONFIG.mobFilter.blacklist;
        if (blacklist.contains(mobId)) {
            return false;
        }
        if (BuffMobsMod.CONFIG.mobFilter.useWhitelist) {
            return BuffMobsMod.CONFIG.mobFilter.whitelist.contains(mobId);
        }
        return true;
    }

    public static double calculateFinalMultiplier(double baseMultiplier, double dimensionMultiplier, double dayMultiplier) {
        if (baseMultiplier > 1.0) {
            return baseMultiplier * dimensionMultiplier * dayMultiplier;
        }
        if (dimensionMultiplier > 1.0) {
            return dimensionMultiplier * dayMultiplier;
        }
        return 1.0;
    }

    public static double calculateFinalAddition(double baseAddition, double dimensionAddition, double dayMultiplier) {
        if (baseAddition > 0.0) {
            return (baseAddition + dimensionAddition) * dayMultiplier;
        }
        if (dimensionAddition > 0.0) {
            return dimensionAddition * dayMultiplier;
        }
        return 0.0;
    }

    public static class DimensionMultipliers {
        public final double health;
        public final double damage;
        public final double speed;
        public final double attackSpeed;
        public final double armor;
        public final double armorToughness;

        public DimensionMultipliers(double health, double damage, double speed, double attackSpeed, double armor, double armorToughness) {
            this.health = health;
            this.damage = damage;
            this.speed = speed;
            this.attackSpeed = attackSpeed;
            this.armor = armor;
            this.armorToughness = armorToughness;
        }
    }
}

