/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.command;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.khotyz.buffmobs.event.MobTickHandler;
import com.khotyz.buffmobs.util.MobBuffUtil;
import com.khotyz.buffmobs.util.MobPresetUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public class DebugCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"buffmobs").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"debug").executes(DebugCommand::debugNearestMob))).then(class_2170.method_9247((String)"reload").executes(DebugCommand::reloadMobs))).then(class_2170.method_9247((String)"info").executes(DebugCommand::showInfo))).then(class_2170.method_9247((String)"presets").executes(DebugCommand::showPresets)));
    }

    private static int debugNearestMob(CommandContext<class_2168> context) {
        class_1324 damage;
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Must be executed by a player!"));
            return 0;
        }
        class_238 searchBox = source.method_44023().method_5829().method_1014(5.0);
        List nearbyMobs = source.method_9225().method_8390(class_1308.class, searchBox, mob -> true);
        if (nearbyMobs.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No mobs nearby! Get closer."));
            return 0;
        }
        class_1308 closestMob = (class_1308)nearbyMobs.get(0);
        double closestDist = source.method_44023().method_5858((class_1297)closestMob);
        for (class_1308 mob2 : nearbyMobs) {
            double dist = source.method_44023().method_5858((class_1297)mob2);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestMob = mob2;
        }
        class_1308 mob3 = closestMob;
        String mobId = class_7923.field_41177.method_10221((Object)mob3.method_5864()).toString();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== BuffMobs Debug ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eMob: \u00a7f" + mob3.method_5864().toString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eMob ID: \u00a7f" + mobId)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eMod ID: \u00a7f" + class_7923.field_41177.method_10221((Object)mob3.method_5864()).method_12836())), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eDimension: \u00a7f" + String.valueOf(mob3.method_73183().method_27983().method_29177()))), false);
        boolean isValid = MobBuffUtil.isValidMob(mob3);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eValid for buffs: \u00a7f" + (isValid ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (!isValid) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cMob is filtered out!"), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Preset System ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePresets Enabled: \u00a7f" + (BuffMobsMod.CONFIG.mobPresets.enabled ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (BuffMobsMod.CONFIG.mobPresets.enabled) {
            MobPresetUtil.PresetMultipliers preset = MobPresetUtil.getPresetForMob(mob3);
            if (preset != null) {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7ePreset Found: \u00a7aYES"), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePreset Health: \u00a7f" + preset.health + "x")), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePreset Damage: \u00a7f" + preset.damage + "x")), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePreset Speed: \u00a7f" + preset.speed + "x")), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePreset Attack Speed: \u00a7f" + preset.attackSpeed + "x")), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePreset Armor: \u00a7f+" + preset.armor)), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePreset Toughness: \u00a7f+" + preset.armorToughness)), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7ePreset Found: \u00a7cNO"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Using dimension/default scaling"), false);
                source.method_9226(() -> class_2561.method_43470((String)""), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Available mappings:"), false);
                for (String mapping : BuffMobsMod.CONFIG.mobPresets.mobMapping) {
                    source.method_9226(() -> class_2561.method_43470((String)("\u00a77  - " + mapping)), false);
                }
                source.method_9226(() -> class_2561.method_43470((String)""), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77To add this mob, use format:"), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a77  " + mobId + ":preset_name")), false);
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Scaling ==="), false);
        double dayMult = MobBuffUtil.getDayMultiplier(mob3.method_73183().method_8532());
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eDay Multiplier: \u00a7f" + String.format("%.2f", dayMult))), false);
        MobBuffUtil.DimensionMultipliers dimMult = MobBuffUtil.getDimensionMultipliers(mob3);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eDim Health Mult: \u00a7f" + dimMult.health)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eDim Damage Mult: \u00a7f" + dimMult.damage)), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Current Stats ==="), false);
        class_1324 health = mob3.method_5996(class_5134.field_23716);
        if (health != null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7eHealth: \u00a7f" + String.format("%.1f / %.1f", Float.valueOf(mob3.method_6032()), health.method_6194()))), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7eBase Health: \u00a7f" + String.format("%.1f", health.method_6201()))), false);
        }
        if ((damage = mob3.method_5996(class_5134.field_23721)) != null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7eAttack Damage: \u00a7f" + String.format("%.1f (base: %.1f)", damage.method_6194(), damage.method_6201()))), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eActive Effects: \u00a7f" + mob3.method_6026().size())), false);
        mob3.method_6026().forEach(effect -> source.method_9226(() -> class_2561.method_43470((String)("  \u00a77- " + ((class_1291)effect.method_5579().comp_349()).method_5560().getString() + " " + (effect.method_5578() + 1))), false));
        return 1;
    }

    private static int showPresets(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== BuffMobs Presets ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eEnabled: \u00a7f" + (BuffMobsMod.CONFIG.mobPresets.enabled ? "\u00a7aYES" : "\u00a7cNO"))), false);
        if (!BuffMobsMod.CONFIG.mobPresets.enabled) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cPresets are disabled in config!"), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Available Presets ==="), false);
        BuffMobsConfig.MobPresets.PresetSlot[] presets = new BuffMobsConfig.MobPresets.PresetSlot[]{BuffMobsMod.CONFIG.mobPresets.preset1, BuffMobsMod.CONFIG.mobPresets.preset2, BuffMobsMod.CONFIG.mobPresets.preset3, BuffMobsMod.CONFIG.mobPresets.preset4, BuffMobsMod.CONFIG.mobPresets.preset5};
        int presetNum = 1;
        for (BuffMobsConfig.MobPresets.PresetSlot preset : presets) {
            if (!preset.presetName.isEmpty()) {
                int num = presetNum;
                source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a7e%d. \u00a7f%s \u00a77(HP: %.1fx, DMG: %.1fx, SPD: %.1fx, ASPD: %.1fx, ARM: +%.0f, TOUGH: +%.0f)", num, preset.presetName, preset.healthMultiplier, preset.damageMultiplier, preset.speedMultiplier, preset.attackSpeedMultiplier, preset.armorAddition, preset.armorToughnessAddition)), false);
            }
            ++presetNum;
        }
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Mob Mappings ==="), false);
        if (BuffMobsMod.CONFIG.mobPresets.mobMapping.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cNo mappings configured!"), false);
        } else {
            for (String mapping : BuffMobsMod.CONFIG.mobPresets.mobMapping) {
                String[] parts = mapping.split(":");
                if (parts.length >= 3) {
                    String mobId = parts[0] + ":" + parts[1];
                    String presetName = parts[2];
                    source.method_9226(() -> class_2561.method_43470((String)("\u00a77- \u00a7f" + mobId + " \u00a77\u2192 \u00a7e" + presetName)), false);
                    continue;
                }
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7c- Invalid: " + mapping)), false);
            }
        }
        return 1;
    }

    private static int reloadMobs(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76Reapplying buffs to all mobs..."), false);
        int count = 0;
        for (class_1297 entity : source.method_9225().method_27909()) {
            if (!(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            try {
                MobBuffUtil.applyBuffs(mob);
                ++count;
            }
            catch (Exception e) {
                BuffMobsMod.LOGGER.error("Failed to buff mob", (Throwable)e);
            }
        }
        int finalCount = count;
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aBuffed " + finalCount + " mobs!")), false);
        return 1;
    }

    private static int showInfo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== BuffMobs Info ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eEnabled: \u00a7f" + BuffMobsMod.CONFIG.enabled)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eInitialized Mobs: \u00a7f" + MobTickHandler.getInitializedCount())), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eHealth Mult: \u00a7f" + BuffMobsMod.CONFIG.attributes.healthMultiplier)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eDamage Mult: \u00a7f" + BuffMobsMod.CONFIG.attributes.damageMultiplier)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eDay Scaling: \u00a7f" + BuffMobsMod.CONFIG.dayScaling.enabled)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7ePresets: \u00a7f" + BuffMobsMod.CONFIG.mobPresets.enabled)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eUse whitelist (mobs): \u00a7f" + BuffMobsMod.CONFIG.mobFilter.useWhitelist)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eUse whitelist (mods): \u00a7f" + BuffMobsMod.CONFIG.modidFilter.useWhitelist)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eUse whitelist (dims): \u00a7f" + BuffMobsMod.CONFIG.dimensionFilter.useWhitelist)), false);
        return 1;
    }
}

