/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.event;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.util.MobBuffUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5819;

public class MobEventHandler {
    private final Map<String, Long> lastDayCheck = new HashMap<String, Long>();
    private final class_5819 random = class_5819.method_43047();

    public void onLivingDamage(class_1309 entity, class_1282 source, float damageTaken) {
        if (!BuffMobsMod.CONFIG.enabled || !BuffMobsMod.CONFIG.harmfulEffects.enabled) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1308 mob;
            class_1676 projectile;
            class_1297 class_12972;
            class_1308 mob2;
            class_1657 player = (class_1657)entity;
            class_1297 attacker = source.method_5529();
            class_1297 directEntity = source.method_5526();
            class_1308 attackingMob = null;
            if (attacker instanceof class_1308 && MobBuffUtil.isValidMob(mob2 = (class_1308)attacker)) {
                attackingMob = mob2;
            } else if (directEntity instanceof class_1676 && (class_12972 = (projectile = (class_1676)directEntity).method_24921()) instanceof class_1308 && MobBuffUtil.isValidMob(mob = (class_1308)class_12972)) {
                attackingMob = mob;
            }
            if (attackingMob != null && (double)this.random.method_43057() < BuffMobsMod.CONFIG.harmfulEffects.chance) {
                this.applyRandomHarmfulEffect(player);
            }
        }
    }

    public void onWorldTick(class_3218 world) {
        if (!BuffMobsMod.CONFIG.enabled) {
            return;
        }
        this.handleDayScaling(world);
    }

    public class_1269 onPlayerAttack(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        return class_1269.field_5811;
    }

    private void handleDayScaling(class_3218 world) {
        if (!BuffMobsMod.CONFIG.dayScaling.enabled || !BuffMobsMod.CONFIG.dayScaling.showNotifications || world.method_18456().isEmpty()) {
            return;
        }
        long currentTime = world.method_8532();
        long currentDay = currentTime / 24000L;
        String worldKey = world.method_27983().method_29177().toString();
        Long lastCheckedDay = this.lastDayCheck.get(worldKey);
        if (lastCheckedDay == null || currentDay > lastCheckedDay) {
            this.lastDayCheck.put(worldKey, currentDay);
            if (lastCheckedDay != null && currentDay > 0L) {
                boolean shouldNotify = false;
                int scalingInterval = BuffMobsMod.CONFIG.dayScaling.interval;
                switch (BuffMobsMod.CONFIG.dayScaling.notificationMode) {
                    case EVERY_DAY: {
                        shouldNotify = true;
                        break;
                    }
                    case SCALING_INCREASE_ONLY: {
                        boolean bl = shouldNotify = currentDay % (long)scalingInterval == 0L;
                    }
                }
                if (shouldNotify) {
                    this.sendDayScalingNotification(world, currentDay);
                }
            }
        }
    }

    private void sendDayScalingNotification(class_3218 world, long currentDay) {
        boolean isMaxed;
        double currentMultiplier = MobBuffUtil.getDayMultiplier(world.method_8532());
        double maxMultiplier = BuffMobsMod.CONFIG.dayScaling.maxMultiplier;
        int scalingInterval = BuffMobsMod.CONFIG.dayScaling.interval;
        long daysUntilNextScaling = (long)scalingInterval - currentDay % (long)scalingInterval;
        if (daysUntilNextScaling == (long)scalingInterval) {
            daysUntilNextScaling = 0L;
        }
        boolean bl = isMaxed = currentMultiplier >= maxMultiplier;
        class_5250 message = isMaxed ? class_2561.method_43470((String)String.format("Day %d - Mob Scaling: %.1fx (MAXIMUM)", currentDay, currentMultiplier)) : class_2561.method_43470((String)String.format("Day %d - Mob Scaling: %.1fx | Next increase in %d day%s", currentDay, currentMultiplier, daysUntilNextScaling, daysUntilNextScaling != 1L ? "s" : ""));
        world.method_18456().forEach(arg_0 -> MobEventHandler.lambda$sendDayScalingNotification$0((class_2561)message, arg_0));
    }

    private void applyRandomHarmfulEffect(class_1657 player) {
        int effectType = this.random.method_43048(3);
        switch (effectType) {
            case 0: {
                MobBuffUtil.applyPoisonToPlayer(player, BuffMobsMod.CONFIG.harmfulEffects.poisonDuration);
                break;
            }
            case 1: {
                MobBuffUtil.applySlownessToPlayer(player, BuffMobsMod.CONFIG.harmfulEffects.slownessDuration);
                break;
            }
            case 2: {
                MobBuffUtil.applyWitherToPlayer(player, BuffMobsMod.CONFIG.harmfulEffects.witherDuration);
            }
        }
    }

    private static /* synthetic */ void lambda$sendDayScalingNotification$0(class_2561 message, class_3222 player) {
        player.method_7353(message, false);
    }
}

