/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.util.MobBuffUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class MeleeWeaponManager {
    private static final class_5819 RANDOM = class_5819.method_43047();

    public static class_1799 generateMeleeWeapon(class_1308 mob) {
        class_1937 world = mob.method_73183();
        String dimensionName = world.method_27983().method_29177().toString();
        double dayMultiplier = MobBuffUtil.getDayMultiplier(world.method_8532());
        class_1799 weapon = MeleeWeaponManager.createWeaponForDimension(dimensionName, dayMultiplier);
        if (BuffMobsMod.CONFIG.rangedMeleeSwitching.enchantmentsEnabled) {
            MeleeWeaponManager.applyEnchantments(weapon, dayMultiplier, world);
        }
        return weapon;
    }

    private static class_1799 createWeaponForDimension(String dimension, double dayMultiplier) {
        List<WeaponTier> availableTiers = MeleeWeaponManager.getAvailableTiers(dimension, dayMultiplier);
        if (availableTiers.isEmpty()) {
            return new class_1799((class_1935)class_1802.field_8528);
        }
        double totalWeight = availableTiers.stream().mapToDouble(t -> t.weight).sum();
        double roll = RANDOM.method_43058() * totalWeight;
        double current = 0.0;
        for (WeaponTier tier : availableTiers) {
            if (!(roll <= (current += tier.weight))) continue;
            return new class_1799((class_1935)tier.item);
        }
        return new class_1799((class_1935)availableTiers.get((int)0).item);
    }

    private static List<WeaponTier> getAvailableTiers(String dimension, double dayMultiplier) {
        ArrayList<WeaponTier> tiers = new ArrayList<WeaponTier>();
        long worldDays = MeleeWeaponManager.calculateWorldDays(dayMultiplier);
        if (dimension.equals("minecraft:the_nether")) {
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.goldenAxeUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8825, 50.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.diamondAxeUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8556, 10.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.netheriteAxeUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_22025, 1.0));
            }
        } else if (dimension.equals("minecraft:overworld")) {
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.stoneSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8528, 50.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.ironSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8371, 30.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.diamondSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8802, 5.0));
            }
        } else if (dimension.equals("minecraft:the_end")) {
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.stoneSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8528, 40.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.ironSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8371, 30.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.diamondSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_8802, 15.0));
            }
            if (worldDays >= (long)BuffMobsMod.CONFIG.rangedMeleeSwitching.netheriteSwordUnlockDay) {
                tiers.add(new WeaponTier(class_1802.field_22022, 1.0));
            }
        } else {
            tiers.add(new WeaponTier(class_1802.field_8528, 60.0));
            tiers.add(new WeaponTier(class_1802.field_8371, 40.0));
        }
        return tiers;
    }

    private static void applyEnchantments(class_1799 weapon, double dayMultiplier, class_1937 world) {
        int maxEnchantments = MeleeWeaponManager.calculateMaxEnchantments(dayMultiplier);
        long worldDays = MeleeWeaponManager.calculateWorldDays(dayMultiplier);
        ArrayList<EnchantmentTier> availableEnchantments = new ArrayList<EnchantmentTier>();
        class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (class_2378<class_1887>)enchantmentRegistry, (class_5321<class_1887>)class_1893.field_9118, worldDays, BuffMobsMod.CONFIG.rangedMeleeSwitching.sharpnessUnlockDay, BuffMobsMod.CONFIG.rangedMeleeSwitching.sharpnessMaxLevel, 40.0, dayMultiplier);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (class_2378<class_1887>)enchantmentRegistry, (class_5321<class_1887>)class_1893.field_9124, worldDays, BuffMobsMod.CONFIG.rangedMeleeSwitching.fireAspectUnlockDay, BuffMobsMod.CONFIG.rangedMeleeSwitching.fireAspectMaxLevel, 25.0, dayMultiplier);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (class_2378<class_1887>)enchantmentRegistry, (class_5321<class_1887>)class_1893.field_9121, worldDays, BuffMobsMod.CONFIG.rangedMeleeSwitching.knockbackUnlockDay, BuffMobsMod.CONFIG.rangedMeleeSwitching.knockbackMaxLevel, 20.0, dayMultiplier);
        MeleeWeaponManager.addEnchantmentIfUnlocked(availableEnchantments, (class_2378<class_1887>)enchantmentRegistry, (class_5321<class_1887>)class_1893.field_9115, worldDays, BuffMobsMod.CONFIG.rangedMeleeSwitching.sweepingEdgeUnlockDay, BuffMobsMod.CONFIG.rangedMeleeSwitching.sweepingEdgeMaxLevel, 15.0, dayMultiplier);
        MeleeWeaponManager.applyRandomEnchantments(weapon, availableEnchantments, maxEnchantments, (class_2378<class_1887>)enchantmentRegistry);
    }

    private static void addEnchantmentIfUnlocked(List<EnchantmentTier> list, class_2378<class_1887> registry, class_5321<class_1887> key, long worldDays, int unlockDay, int maxLevel, double weight, double dayMultiplier) {
        if (worldDays >= (long)unlockDay) {
            int level = MeleeWeaponManager.calculateEnchantmentLevel(maxLevel, unlockDay, dayMultiplier);
            list.add(new EnchantmentTier(key, level, weight));
        }
    }

    private static void applyRandomEnchantments(class_1799 weapon, List<EnchantmentTier> available, int maxCount, class_2378<class_1887> registry) {
        int toApply = Math.min(maxCount, available.size());
        ArrayList<EnchantmentTier> remaining = new ArrayList<EnchantmentTier>(available);
        for (int i = 0; i < toApply && !remaining.isEmpty(); ++i) {
            class_6880 entry;
            double totalWeight = remaining.stream().mapToDouble(e -> e.weight).sum();
            double roll = RANDOM.method_43058() * totalWeight;
            double current = 0.0;
            EnchantmentTier selected = null;
            for (EnchantmentTier ench : remaining) {
                if (!(roll <= (current += ench.weight))) continue;
                selected = ench;
                break;
            }
            if (selected == null) continue;
            class_1887 enchantment = (class_1887)registry.method_29107(selected.enchantmentKey);
            if (enchantment != null && (entry = registry.method_47983((Object)enchantment)) != null) {
                weapon.method_7978(entry, selected.level);
            }
            remaining.remove(selected);
        }
    }

    private static int calculateMaxEnchantments(double dayMultiplier) {
        int baseMax = BuffMobsMod.CONFIG.rangedMeleeSwitching.maxEnchantmentsPerWeapon;
        if (dayMultiplier >= 3.0) {
            return Math.min(4, baseMax);
        }
        if (dayMultiplier >= 2.0) {
            return Math.min(3, baseMax);
        }
        if (dayMultiplier >= 1.5) {
            return Math.min(2, baseMax);
        }
        return Math.min(1, baseMax);
    }

    private static int calculateEnchantmentLevel(int maxLevel, int unlockDay, double dayMultiplier) {
        if (maxLevel <= 1) {
            return 1;
        }
        long worldDays = MeleeWeaponManager.calculateWorldDays(dayMultiplier);
        long daysAfterUnlock = Math.max(0L, worldDays - (long)unlockDay);
        int daysPerLevel = BuffMobsMod.CONFIG.rangedMeleeSwitching.daysPerEnchantmentLevel;
        int level = 1 + (int)(daysAfterUnlock / (long)daysPerLevel);
        return Math.min(level, maxLevel);
    }

    private static long calculateWorldDays(double dayMultiplier) {
        if (dayMultiplier <= 1.0) {
            return 0L;
        }
        return (long)((dayMultiplier - 1.0) / BuffMobsMod.CONFIG.dayScaling.multiplier) * (long)BuffMobsMod.CONFIG.dayScaling.interval;
    }

    private static class WeaponTier {
        final class_1792 item;
        final double weight;

        WeaponTier(class_1792 item, double weight) {
            this.item = item;
            this.weight = weight;
        }
    }

    private static class EnchantmentTier {
        final class_5321<class_1887> enchantmentKey;
        final int level;
        final double weight;

        EnchantmentTier(class_5321<class_1887> key, int level, double weight) {
            this.enchantmentKey = key;
            this.level = level;
            this.weight = weight;
        }
    }
}

