/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import net.minecraft.class_1308;
import net.minecraft.class_7923;

public class MobPresetUtil {
    public static PresetMultipliers getPresetForMob(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.mobPresets.enabled) {
            BuffMobsMod.LOGGER.debug("Mob presets disabled in config");
            return null;
        }
        String mobId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        String presetName = null;
        BuffMobsMod.LOGGER.debug("Checking preset for mob: {}", (Object)mobId);
        BuffMobsMod.LOGGER.debug("Available mappings: {}", BuffMobsMod.CONFIG.mobPresets.mobMapping);
        for (String mapping : BuffMobsMod.CONFIG.mobPresets.mobMapping) {
            String[] parts = mapping.split(":");
            if (parts.length >= 3) {
                String mappedMobId = parts[0] + ":" + parts[1];
                String mappedPreset = parts[2];
                BuffMobsMod.LOGGER.debug("Checking mapping: {} -> {}", (Object)mappedMobId, (Object)mappedPreset);
                if (!mappedMobId.equals(mobId)) continue;
                presetName = mappedPreset;
                BuffMobsMod.LOGGER.debug("Found matching preset: {}", (Object)presetName);
                break;
            }
            BuffMobsMod.LOGGER.warn("Invalid mapping format: '{}' (expected format: 'mobid:presetname')", (Object)mapping);
        }
        if (presetName == null || presetName.isEmpty()) {
            BuffMobsMod.LOGGER.debug("No preset found for mob: {}", (Object)mobId);
            return null;
        }
        BuffMobsConfig.MobPresets.PresetSlot preset = MobPresetUtil.findPresetByName(presetName);
        if (preset == null || preset.presetName.isEmpty()) {
            BuffMobsMod.LOGGER.warn("Preset '{}' not found or empty for mob '{}'", (Object)presetName, (Object)mobId);
            return null;
        }
        BuffMobsMod.LOGGER.info("Applied preset '{}' to mob '{}': health={}, damage={}", new Object[]{presetName, mobId, preset.healthMultiplier, preset.damageMultiplier});
        return new PresetMultipliers(preset.healthMultiplier, preset.damageMultiplier, preset.speedMultiplier, preset.attackSpeedMultiplier, preset.armorAddition, preset.armorToughnessAddition);
    }

    private static BuffMobsConfig.MobPresets.PresetSlot findPresetByName(String name) {
        BuffMobsConfig.MobPresets.PresetSlot[] presets;
        for (BuffMobsConfig.MobPresets.PresetSlot preset : presets = new BuffMobsConfig.MobPresets.PresetSlot[]{BuffMobsMod.CONFIG.mobPresets.preset1, BuffMobsMod.CONFIG.mobPresets.preset2, BuffMobsMod.CONFIG.mobPresets.preset3, BuffMobsMod.CONFIG.mobPresets.preset4, BuffMobsMod.CONFIG.mobPresets.preset5}) {
            BuffMobsMod.LOGGER.debug("Comparing preset name '{}' with '{}'", (Object)preset.presetName, (Object)name);
            if (!preset.presetName.equals(name)) continue;
            BuffMobsMod.LOGGER.debug("Preset match found!");
            return preset;
        }
        BuffMobsMod.LOGGER.debug("No preset matched for name: {}", (Object)name);
        return null;
    }

    public static class PresetMultipliers {
        public final double health;
        public final double damage;
        public final double speed;
        public final double attackSpeed;
        public final double armor;
        public final double armorToughness;

        public PresetMultipliers(double health, double damage, double speed, double attackSpeed, double armor, double armorToughness) {
            this.health = health;
            this.damage = damage;
            this.speed = speed;
            this.attackSpeed = attackSpeed;
            this.armor = armor;
            this.armorToughness = armorToughness;
        }
    }
}

