/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.config;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.config.BuffMobsConfig;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_403;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<class_437> getModConfigScreenFactory() {
        return parent -> {
            try {
                Supplier supplier;
                class_437 screen;
                Class<?> autoConfigClass = Class.forName("me.shedaniel.autoconfig.AutoConfig");
                Class<?> configHolderClass = Class.forName("me.shedaniel.autoconfig.ConfigHolder");
                Object configHolder = autoConfigClass.getMethod("getConfigHolder", Class.class).invoke(null, BuffMobsConfig.class);
                Method getConfigScreenMethod = autoConfigClass.getMethod("getConfigScreen", Class.class, class_437.class);
                Object screenSupplier = getConfigScreenMethod.invoke(null, BuffMobsConfig.class, parent);
                if (screenSupplier instanceof Supplier && (screen = (class_437)(supplier = (Supplier)screenSupplier).get()) != null) {
                    return screen;
                }
                return this.createFallbackScreen(parent, "Config screen creation failed");
            }
            catch (ClassNotFoundException e) {
                return this.createErrorScreen(parent, "Cloth Config Missing", "Cloth Config API v19.0.147+ required for configuration screen.\n\nDownload from:\n- CurseForge: Cloth Config API\n- Modrinth: Cloth Config API\n\nManual config: config/buffmobs.json5");
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                return this.createErrorScreen(parent, "Incompatible Version", "Incompatible Cloth Config version detected.\n\nRequired: v19.0.147+fabric or later\nFor Minecraft 1.21.6-1.21.8\n\nManual config: config/buffmobs.json5");
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NoSuchMethodError) {
                    return this.createErrorScreen(parent, "Method Compatibility Issue", "Cloth Config method signature mismatch.\n\nThis usually means version incompatibility.\nTry Cloth Config v19.0.147+fabric\n\nManual config: config/buffmobs.json5");
                }
                BuffMobsMod.LOGGER.error("Config screen invocation failed", (Throwable)e);
                return this.createFallbackScreen(parent, "Screen creation error: " + cause.getMessage());
            }
            catch (Exception e) {
                BuffMobsMod.LOGGER.error("Unexpected config screen error", (Throwable)e);
                return this.createFallbackScreen(parent, "Unexpected error: " + e.getClass().getSimpleName());
            }
        };
    }

    private class_437 createFallbackScreen(class_437 parent, String reason) {
        return new class_403(() -> class_310.method_1551().method_1507(parent), (class_2561)class_2561.method_43470((String)"BuffMobs Configuration"), (class_2561)class_2561.method_43470((String)("Config GUI temporarily unavailable.\n\nReason: " + reason + "\n\nManual configuration:\nEdit config/buffmobs.json5\nRestart game after changes.\n\nFor GUI support, install:\nCloth Config API v19.0.147+fabric")));
    }

    private class_437 createErrorScreen(class_437 parent, String title, String message) {
        return new class_403(() -> class_310.method_1551().method_1507(parent), (class_2561)class_2561.method_43470((String)("BuffMobs - " + title)), (class_2561)class_2561.method_43470((String)message));
    }
}

