/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.util.MobBuffUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class MeleeWeaponManager {
    private static final class_5819 RANDOM = class_5819.method_43047();

    public static class_1799 generateMeleeWeapon(class_1308 mob) {
        class_1937 world = mob.method_37908();
        String dimensionName = world.method_27983().method_29177().toString();
        double dayMultiplier = MobBuffUtil.getDayMultiplier(world.method_8532());
        class_1799 weapon = MeleeWeaponManager.createWeaponForDimension(dimensionName, dayMultiplier);
        if (BuffMobsMod.CONFIG.rangedMeleeSwitching.enchantmentsEnabled) {
            MeleeWeaponManager.applyEnchantments(weapon, dayMultiplier, world);
        }
        return weapon;
    }

    private static class_1799 createWeaponForDimension(String dimension, double dayMultiplier) {
        List<WeaponTier> availableTiers = MeleeWeaponManager.getAvailableTiers(dimension, dayMultiplier);
        if (availableTiers.isEmpty()) {
            return new class_1799((class_1935)class_1802.field_8528);
        }
        double totalWeight = availableTiers.stream().mapToDouble(t -> t.weight).sum();
        double roll = RANDOM.method_43058() * totalWeight;
        double current = 0.0;
        for (WeaponTier tier : availableTiers) {
            if (!(roll <= (current += tier.weight))) continue;
            return new class_1799((class_1935)tier.item);
        }
        return new class_1799((class_1935)availableTiers.get((int)0).item);
    }

    private static List<WeaponTier> getAvailableTiers(String dimension, double dayMultiplier) {
        ArrayList<WeaponTier> tiers = new ArrayList<WeaponTier>();
        boolean isOverworld = dimension.equals("minecraft:overworld");
        boolean isNether = dimension.equals("minecraft:the_nether");
        boolean isEnd = dimension.equals("minecraft:the_end");
        if (isNether) {
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.goldenAxeUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8825, 50.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.diamondAxeUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8556, 10.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.netheriteAxeUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_22025, 1.0));
            }
        } else if (isOverworld) {
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.stoneSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8528, 50.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.ironSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8371, 30.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.diamondSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8802, 5.0));
            }
        } else if (isEnd) {
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.stoneSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8528, 40.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.ironSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8371, 30.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.diamondSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_8802, 15.0));
            }
            if (MeleeWeaponManager.shouldUnlockTier(BuffMobsMod.CONFIG.rangedMeleeSwitching.netheriteSwordUnlockDay, dayMultiplier)) {
                tiers.add(new WeaponTier(class_1802.field_22022, 1.0));
            }
        } else {
            tiers.add(new WeaponTier(class_1802.field_8528, 60.0));
            tiers.add(new WeaponTier(class_1802.field_8371, 40.0));
        }
        return tiers;
    }

    private static boolean shouldUnlockTier(int unlockDay, double dayMultiplier) {
        if (unlockDay <= 0) {
            return true;
        }
        long worldDays = (long)((dayMultiplier - 1.0) / BuffMobsMod.CONFIG.dayScaling.multiplier) * (long)BuffMobsMod.CONFIG.dayScaling.interval;
        return worldDays >= (long)unlockDay;
    }

    private static void applyEnchantments(class_1799 weapon, double dayMultiplier, class_1937 world) {
        int level;
        int maxEnchantments = MeleeWeaponManager.calculateMaxEnchantments(dayMultiplier);
        ArrayList<EnchantmentTier> availableEnchantments = new ArrayList<EnchantmentTier>();
        if (MeleeWeaponManager.shouldUnlockEnchantment(BuffMobsMod.CONFIG.rangedMeleeSwitching.sharpnessUnlockDay, dayMultiplier)) {
            level = MeleeWeaponManager.calculateEnchantmentLevel(BuffMobsMod.CONFIG.rangedMeleeSwitching.sharpnessMaxLevel, BuffMobsMod.CONFIG.rangedMeleeSwitching.sharpnessUnlockDay, dayMultiplier);
            availableEnchantments.add(new EnchantmentTier((class_5321<class_1887>)class_1893.field_9118, level, 40.0));
        }
        if (MeleeWeaponManager.shouldUnlockEnchantment(BuffMobsMod.CONFIG.rangedMeleeSwitching.fireAspectUnlockDay, dayMultiplier)) {
            level = MeleeWeaponManager.calculateEnchantmentLevel(BuffMobsMod.CONFIG.rangedMeleeSwitching.fireAspectMaxLevel, BuffMobsMod.CONFIG.rangedMeleeSwitching.fireAspectUnlockDay, dayMultiplier);
            availableEnchantments.add(new EnchantmentTier((class_5321<class_1887>)class_1893.field_9124, level, 25.0));
        }
        if (MeleeWeaponManager.shouldUnlockEnchantment(BuffMobsMod.CONFIG.rangedMeleeSwitching.knockbackUnlockDay, dayMultiplier)) {
            level = MeleeWeaponManager.calculateEnchantmentLevel(BuffMobsMod.CONFIG.rangedMeleeSwitching.knockbackMaxLevel, BuffMobsMod.CONFIG.rangedMeleeSwitching.knockbackUnlockDay, dayMultiplier);
            availableEnchantments.add(new EnchantmentTier((class_5321<class_1887>)class_1893.field_9121, level, 20.0));
        }
        if (MeleeWeaponManager.shouldUnlockEnchantment(BuffMobsMod.CONFIG.rangedMeleeSwitching.sweepingEdgeUnlockDay, dayMultiplier)) {
            level = MeleeWeaponManager.calculateEnchantmentLevel(BuffMobsMod.CONFIG.rangedMeleeSwitching.sweepingEdgeMaxLevel, BuffMobsMod.CONFIG.rangedMeleeSwitching.sweepingEdgeUnlockDay, dayMultiplier);
            availableEnchantments.add(new EnchantmentTier((class_5321<class_1887>)class_1893.field_9115, level, 15.0));
        }
        int enchantmentsToApply = Math.min(maxEnchantments, availableEnchantments.size());
        ArrayList shuffled = new ArrayList(availableEnchantments);
        for (int i = 0; i < enchantmentsToApply && !shuffled.isEmpty(); ++i) {
            double totalWeight = shuffled.stream().mapToDouble(e -> e.weight).sum();
            double roll = RANDOM.method_43058() * totalWeight;
            double current = 0.0;
            EnchantmentTier selected = null;
            for (EnchantmentTier ench : shuffled) {
                if (!(roll <= (current += ench.weight))) continue;
                selected = ench;
                break;
            }
            if (selected == null) continue;
            try {
                class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
                class_1887 enchantment = (class_1887)enchantmentRegistry.method_29107(selected.enchantmentKey);
                if (enchantment != null) {
                    class_6880 enchantmentEntry = enchantmentRegistry.method_47983((Object)enchantment);
                    weapon.method_7978(enchantmentEntry, selected.level);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            shuffled.remove(selected);
        }
    }

    private static int calculateMaxEnchantments(double dayMultiplier) {
        int baseMax = BuffMobsMod.CONFIG.rangedMeleeSwitching.maxEnchantmentsPerWeapon;
        if (dayMultiplier >= 3.0) {
            return Math.min(4, baseMax);
        }
        if (dayMultiplier >= 2.0) {
            return Math.min(3, baseMax);
        }
        if (dayMultiplier >= 1.5) {
            return Math.min(2, baseMax);
        }
        return Math.min(1, baseMax);
    }

    private static boolean shouldUnlockEnchantment(int unlockDay, double dayMultiplier) {
        if (unlockDay <= 0) {
            return true;
        }
        long worldDays = (long)((dayMultiplier - 1.0) / BuffMobsMod.CONFIG.dayScaling.multiplier) * (long)BuffMobsMod.CONFIG.dayScaling.interval;
        return worldDays >= (long)unlockDay;
    }

    private static int calculateEnchantmentLevel(int maxLevel, int unlockDay, double dayMultiplier) {
        if (maxLevel <= 1) {
            return 1;
        }
        long worldDays = (long)((dayMultiplier - 1.0) / BuffMobsMod.CONFIG.dayScaling.multiplier) * (long)BuffMobsMod.CONFIG.dayScaling.interval;
        long daysAfterUnlock = Math.max(0L, worldDays - (long)unlockDay);
        int daysPerLevel = BuffMobsMod.CONFIG.rangedMeleeSwitching.daysPerEnchantmentLevel;
        int level = 1 + (int)(daysAfterUnlock / (long)daysPerLevel);
        return Math.min(level, maxLevel);
    }

    private static class WeaponTier {
        final class_1792 item;
        final double weight;

        WeaponTier(class_1792 item, double weight) {
            this.item = item;
            this.weight = weight;
        }
    }

    private static class EnchantmentTier {
        final class_5321<class_1887> enchantmentKey;
        final int level;
        final double weight;

        EnchantmentTier(class_5321<class_1887> enchantmentKey, int level, double weight) {
            this.enchantmentKey = enchantmentKey;
            this.level = level;
            this.weight = weight;
        }
    }
}

