/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.event;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.util.MobBuffUtil;
import com.khotyz.buffmobs.util.RangedMobAIManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class MobTickHandler {
    private static final Set<UUID> INITIALIZED_MOBS = new HashSet<UUID>();
    private static int globalTickCounter = 0;
    private static boolean initialScanDone = false;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            BuffMobsMod.LOGGER.info("Server started - scanning for existing mobs...");
            int count = 0;
            for (class_3218 world : server.method_3738()) {
                for (class_1297 entity : world.method_27909()) {
                    if (!(entity instanceof class_1308)) continue;
                    class_1308 mob = (class_1308)entity;
                    MobTickHandler.initializeMob(mob);
                    ++count;
                }
            }
            BuffMobsMod.LOGGER.info("Initialized {} existing mobs", (Object)count);
            initialScanDone = true;
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                if (!world.method_8608() && !INITIALIZED_MOBS.contains(mob.method_5667())) {
                    MobTickHandler.initializeMob(mob);
                }
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(MobTickHandler::onWorldTick);
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (entity instanceof class_1308) {
                INITIALIZED_MOBS.remove(entity.method_5667());
                RangedMobAIManager.cleanup((class_1308)entity);
            }
        });
    }

    private static void initializeMob(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.enabled) {
            return;
        }
        UUID uuid = mob.method_5667();
        if (INITIALIZED_MOBS.contains(uuid)) {
            return;
        }
        try {
            if (MobBuffUtil.isValidMob(mob)) {
                MobBuffUtil.applyBuffs(mob);
                RangedMobAIManager.initializeMob(mob);
                INITIALIZED_MOBS.add(uuid);
                if (BuffMobsMod.LOGGER.isDebugEnabled()) {
                    BuffMobsMod.LOGGER.debug("Initialized mob: {} ({}) in {}", new Object[]{class_7923.field_41177.method_10221((Object)mob.method_5864()), mob.method_5667(), mob.method_73183().method_27983().method_29177()});
                }
            } else if (BuffMobsMod.LOGGER.isDebugEnabled()) {
                BuffMobsMod.LOGGER.debug("Skipped invalid mob: {} in {}", (Object)class_7923.field_41177.method_10221((Object)mob.method_5864()), (Object)mob.method_73183().method_27983().method_29177());
            }
        }
        catch (Exception e) {
            BuffMobsMod.LOGGER.error("Failed to initialize mob: {}", (Object)mob.method_5864(), (Object)e);
        }
    }

    private static void onWorldTick(class_3218 world) {
        if (!BuffMobsMod.CONFIG.enabled) {
            return;
        }
        if (++globalTickCounter % 100 == 0 && !initialScanDone) {
            for (class_1297 entity2 : world.method_27909()) {
                class_1308 mob;
                if (!(entity2 instanceof class_1308) || INITIALIZED_MOBS.contains((mob = (class_1308)entity2).method_5667())) continue;
                MobTickHandler.initializeMob(mob);
            }
        }
        if (globalTickCounter % 20 == 0) {
            world.method_27909().forEach(entity -> {
                class_1308 mob;
                if (entity instanceof class_1308 && !(mob = (class_1308)entity).method_31481()) {
                    UUID uuid = mob.method_5667();
                    if (!INITIALIZED_MOBS.contains(uuid)) {
                        MobTickHandler.initializeMob(mob);
                    } else {
                        try {
                            RangedMobAIManager.updateMobBehavior(mob);
                            MobBuffUtil.refreshInfiniteEffects(mob);
                        }
                        catch (Exception e) {
                            BuffMobsMod.LOGGER.warn("Error updating mob behavior", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public static int getInitializedCount() {
        return INITIALIZED_MOBS.size();
    }
}

