/*
 * Decompiled with CFR 0.152.
 */
package com.khotyz.buffmobs.util;

import com.khotyz.buffmobs.BuffMobsMod;
import com.khotyz.buffmobs.util.MeleeWeaponManager;
import com.khotyz.buffmobs.util.MobEntityAccessor;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1380;
import net.minecraft.class_1381;
import net.minecraft.class_1383;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_4135;
import net.minecraft.class_4836;
import net.minecraft.class_7923;

public class RangedMobAIManager {
    private static final Map<class_1308, MeleeState> MELEE_STATES = new WeakHashMap<class_1308, MeleeState>();
    private static final double MELEE_SPEED_MULTIPLIER = 1.0;

    public static void initializeMob(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.rangedMeleeSwitching.enabled) {
            return;
        }
        if (!RangedMobAIManager.isRangedMob(mob)) {
            return;
        }
        if (MELEE_STATES.containsKey(mob)) {
            return;
        }
        MeleeState state = new MeleeState();
        state.originalMainHand = mob.method_5998(class_1268.field_5808).method_7972();
        MELEE_STATES.put(mob, state);
    }

    public static void updateMobBehavior(class_1308 mob) {
        if (!BuffMobsMod.CONFIG.rangedMeleeSwitching.enabled) {
            return;
        }
        if (!RangedMobAIManager.isRangedMob(mob)) {
            return;
        }
        MeleeState state = MELEE_STATES.get(mob);
        if (state == null) {
            return;
        }
        class_1657 nearestPlayer = mob.method_37908().method_18460((class_1297)mob, 32.0);
        if (nearestPlayer == null || nearestPlayer.method_7325() || nearestPlayer.method_68878()) {
            if (state.inMeleeMode) {
                RangedMobAIManager.switchToRangedMode(mob, state);
            }
            return;
        }
        double distance = mob.method_5739((class_1297)nearestPlayer);
        double switchDistance = BuffMobsMod.CONFIG.rangedMeleeSwitching.switchDistance;
        long currentTime = mob.method_37908().method_8510();
        long timeSinceSwitch = currentTime - state.lastSwitchTime;
        if (timeSinceSwitch < 40L) {
            return;
        }
        if (!state.inMeleeMode && distance <= switchDistance) {
            RangedMobAIManager.switchToMeleeMode(mob, state);
        } else if (state.inMeleeMode && distance > switchDistance + 2.0) {
            RangedMobAIManager.switchToRangedMode(mob, state);
        }
    }

    private static void switchToMeleeMode(class_1308 mob, MeleeState state) {
        if (state.originalMainHand.method_7960()) {
            state.originalMainHand = mob.method_5998(class_1268.field_5808).method_7972();
        }
        class_1799 meleeWeapon = MeleeWeaponManager.generateMeleeWeapon(mob);
        mob.method_5673(class_1304.field_6173, meleeWeapon);
        mob.method_6122(class_1268.field_5808, meleeWeapon);
        if (state.meleeGoal == null && mob instanceof class_1314) {
            class_1314 pathAwareMob = (class_1314)mob;
            state.meleeGoal = new class_1366(pathAwareMob, 1.0, false);
            try {
                MobEntityAccessor.addGoal(mob, 2, state.meleeGoal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        state.inMeleeMode = true;
        state.lastSwitchTime = mob.method_37908().method_8510();
    }

    private static void switchToRangedMode(class_1308 mob, MeleeState state) {
        class_1799 rangedWeapon = !state.originalMainHand.method_7960() ? state.originalMainHand.method_7972() : RangedMobAIManager.getDefaultRangedWeapon(mob);
        mob.method_5673(class_1304.field_6173, rangedWeapon);
        mob.method_6122(class_1268.field_5808, rangedWeapon);
        if (state.meleeGoal != null) {
            try {
                MobEntityAccessor.removeGoal(mob, state.meleeGoal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            state.meleeGoal = null;
        }
        state.inMeleeMode = false;
        state.lastSwitchTime = mob.method_37908().method_8510();
    }

    private static class_1799 getDefaultRangedWeapon(class_1308 mob) {
        if (mob instanceof class_1613 || mob instanceof class_1627 || mob instanceof class_1639) {
            return new class_1799((class_1935)class_1802.field_8102);
        }
        if (mob instanceof class_4836 || mob instanceof class_1604) {
            return new class_1799((class_1935)class_1802.field_8399);
        }
        return class_1799.field_8037;
    }

    public static boolean isRangedMob(class_1308 mob) {
        String mobId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        if (BuffMobsMod.CONFIG.rangedMeleeSwitching.customRangedMobs.contains(mobId)) {
            return true;
        }
        if (mob instanceof class_1613 || mob instanceof class_1627 || mob instanceof class_1639 || mob instanceof class_4836 || mob instanceof class_1604) {
            return true;
        }
        try {
            for (class_4135 goal : MobEntityAccessor.getGoals(mob)) {
                class_1352 prioritizedGoal = goal.method_19058();
                if (!(prioritizedGoal instanceof class_1380) && !(prioritizedGoal instanceof class_1383) && !(prioritizedGoal instanceof class_1381)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInMeleeMode(class_1308 mob) {
        MeleeState state = MELEE_STATES.get(mob);
        return state != null && state.inMeleeMode;
    }

    private static class MeleeState {
        boolean inMeleeMode = false;
        class_1799 originalMainHand = class_1799.field_8037;
        long lastSwitchTime = 0L;
        class_1352 meleeGoal = null;

        private MeleeState() {
        }
    }
}

