/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.modsmod.util;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class IOUtil {
    public static void deleteRecursive(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void clearDirectory(Path path) throws IOException {
        IOUtil.deleteRecursive(path);
        Files.createDirectory(path, new FileAttribute[0]);
    }

    public static boolean contentEquals(Path a, Path b) throws IOException {
        try (FileChannel fca = FileChannel.open(a, StandardOpenOption.READ);){
            boolean bl;
            block12: {
                FileChannel fcb = FileChannel.open(b, StandardOpenOption.READ);
                try {
                    MappedByteBuffer mbba = fca.map(FileChannel.MapMode.READ_ONLY, 0L, fca.size());
                    MappedByteBuffer mbbb = fcb.map(FileChannel.MapMode.READ_ONLY, 0L, fcb.size());
                    bl = mbba.equals(mbbb);
                    if (fcb == null) break block12;
                }
                catch (Throwable throwable) {
                    if (fcb != null) {
                        try {
                            fcb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fcb.close();
            }
            return bl;
        }
    }
}

