/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.modsmod.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class IteratorCallbackList<T>
implements List<T> {
    private final List<T> containers;
    private final Consumer<List<T>> reset;
    private final Runnable callback;
    boolean modified = false;

    public IteratorCallbackList(List<T> base, Consumer<List<T>> reset, Runnable callback) {
        this.containers = Collections.synchronizedList(base);
        this.reset = reset;
        this.callback = callback;
    }

    @Override
    public int size() {
        return this.containers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.containers.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.containers.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        if (!this.modified) {
            this.callback.run();
            this.modified = true;
        }
        this.reset.accept(this.containers);
        return this.containers.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.containers.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] ts) {
        return this.containers.toArray(ts);
    }

    @Override
    public boolean add(T modContainer) {
        return this.containers.add(modContainer);
    }

    @Override
    public boolean remove(Object o) {
        return this.containers.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.containers.containsAll(collection);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        return this.containers.addAll(collection);
    }

    @Override
    public boolean addAll(int i, @NotNull Collection<? extends T> collection) {
        return this.containers.addAll(i, collection);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        return this.containers.removeAll(collection);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        return this.containers.retainAll(collection);
    }

    @Override
    public void clear() {
        this.containers.clear();
    }

    @Override
    public T get(int i) {
        return this.containers.get(i);
    }

    @Override
    public T set(int i, T modContainer) {
        return this.containers.set(i, modContainer);
    }

    @Override
    public void add(int i, T modContainer) {
        this.containers.add(i, modContainer);
    }

    @Override
    public T remove(int i) {
        return this.containers.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.containers.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.containers.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.containers.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int i) {
        return this.containers.listIterator(i);
    }

    @Override
    @NotNull
    public List<T> subList(int i, int i1) {
        return this.containers.subList(i, i1);
    }
}

