/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.modsmod;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.unsafe.UltraEarlyInit;
import io.gitlab.jfronny.modsmod.FabricLoaderInterface;
import io.gitlab.jfronny.modsmod.JFC_ModsModConfig;
import io.gitlab.jfronny.modsmod.ModsModConfig;
import io.gitlab.jfronny.modsmod.builder.JsonBuilder;
import io.gitlab.jfronny.modsmod.builder.ModMeta;
import io.gitlab.jfronny.modsmod.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.ModMetadataParser;
import net.fabricmc.loader.impl.metadata.ParseMetadataException;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import net.fabricmc.loader.impl.util.FileSystemUtil;

public class ModsMod
implements UltraEarlyInit {
    static final HashSet<ModMeta> MODS = new HashSet();
    static final FabricLoaderImpl LOADER = FabricLoaderImpl.INSTANCE;
    public static final String MOD_ID = "modsmod";
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName((String)"modsmod");
    private static final String CACHE_NAME = "modsmodcache";

    public void init() {
        try {
            JFC_ModsModConfig.ensureInitialized();
            Path modsmodCfgFile = (Path)ConfigInstance.get((String)MOD_ID).getFilePath().orElseThrow();
            Path path = LOADER.getConfigDir().resolve(CACHE_NAME);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                Files.createDirectories(path, new FileAttribute[0]);
            }
            try {
                Path cfgCache = path.resolve("_basecfg");
                if (Files.exists(cfgCache, new LinkOption[0])) {
                    if (Files.isRegularFile(cfgCache, new LinkOption[0])) {
                        if (!IOUtil.contentEquals(modsmodCfgFile, cfgCache)) {
                            IOUtil.clearDirectory(path);
                        }
                    } else {
                        IOUtil.clearDirectory(path);
                    }
                }
                Files.copy(modsmodCfgFile, cfgCache, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("Failed to validate modsmod config cache, caching will not be available", (Throwable)e);
            }
            MODS.clear();
            for (int i = 0; i < ModsModConfig.modsCount; ++i) {
                Path f = path.resolve("f" + (i + 1) + ".jar");
                boolean exists = Files.exists(f, new LinkOption[0]);
                if (exists) {
                    if (ModsModConfig.cache) {
                        MODS.add(new ModMeta(f));
                        continue;
                    }
                    Files.delete(f);
                }
                try (FileSystem fs = FileSystemUtil.getJarFileSystem((Path)f, (boolean)true).get();){
                    Path inf = fs.getPath("META-INF", new String[0]);
                    Files.createDirectory(inf, new FileAttribute[0]);
                    Files.writeString(inf.resolve("MANIFEST.MF"), (CharSequence)"Manifest-Version: 1.0\n", new OpenOption[0]);
                    JsonBuilder.build(i + 1, ModMeta.getFmj(fs), ModsModConfig.parent);
                }
                MODS.add(new ModMeta(f));
                System.gc();
            }
            FabricLoaderInterface.synchronize(LOADER);
        }
        catch (IOException e) {
            LOGGER.error("Could not create modsmod mods", (Throwable)e);
        }
    }

    public static void loadMods() {
        for (ModMeta meta : MODS) {
            try {
                LoaderModMetadata info = ModMetadataParser.parseMetadata((InputStream)Files.newInputStream(meta.fmj, new OpenOption[0]), (String)meta.url.toString(), new ArrayList(), (VersionOverrides)new VersionOverrides(), (DependencyOverrides)new DependencyOverrides(FabricLoader.getInstance().getConfigDir()), (boolean)false);
                FabricLoaderInterface.addMod(LOADER, FabricLoaderInterface.createPlain(meta.rootPath, info, false, new HashSet<ModCandidateImpl>()));
            }
            catch (IOException | ParseMetadataException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

